/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.exec.rulefilters;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.windup.config.RuleProvider;
import org.jboss.windup.config.metadata.TechnologyReference;

public class SourceAndTargetPredicate
implements Predicate<RuleProvider> {
    private final Set<String> sources;
    private final Set<String> targets;

    public SourceAndTargetPredicate(Collection<String> sources, Collection<String> targets) {
        this.sources = this.initSet(sources);
        this.targets = this.initSet(targets);
    }

    public boolean accept(RuleProvider type) {
        Set providerSources = type.getMetadata().getSourceTechnologies();
        Set providerTargets = type.getMetadata().getTargetTechnologies();
        return this.techMatches(this.sources, providerSources) && this.techMatches(this.targets, providerTargets);
    }

    private boolean techMatches(Set<String> techs, Set<TechnologyReference> technologyReferences) {
        if (techs.isEmpty() || technologyReferences.isEmpty()) {
            return true;
        }
        for (TechnologyReference technologyReference : technologyReferences) {
            if (!techs.contains(technologyReference.getId())) continue;
            return true;
        }
        return false;
    }

    private Set<String> initSet(Collection<String> values) {
        if (values == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(values);
    }

    public String toString() {
        return "SourceAndTargetPredicate{sources=" + this.sources + ", targets=" + this.targets + '}';
    }
}

