/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.exec.configuration.options;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import org.jboss.windup.config.AbstractPathConfigurationOption;
import org.jboss.windup.config.InputType;
import org.jboss.windup.config.ValidationResult;

public class OutputPathOption
extends AbstractPathConfigurationOption {
    public static final String NAME = "output";

    public OutputPathOption() {
        super(false);
    }

    public String getName() {
        return NAME;
    }

    public String getLabel() {
        return "Output";
    }

    public String getDescription() {
        return "Output Directory (WARNING: any existing files will be removed).";
    }

    public InputType getUIType() {
        return InputType.DIRECTORY;
    }

    public boolean isRequired() {
        return false;
    }

    public int getPriority() {
        return 9000;
    }

    public static ValidationResult validateInputAndOutputPath(Path inputPath, Path outputPath) {
        return OutputPathOption.validateInputsAndOutputPaths(Collections.singletonList(inputPath), outputPath);
    }

    public static ValidationResult validateInputsAndOutputPaths(Collection inputPaths, Path outputPath) {
        if (inputPaths == null || inputPaths.isEmpty()) {
            return new ValidationResult(ValidationResult.Level.ERROR, "Input path must be specified.");
        }
        if (outputPath == null) {
            return new ValidationResult(ValidationResult.Level.ERROR, "Output path must be specified.");
        }
        File outputFile = outputPath.toFile();
        boolean nonNullInputFound = false;
        for (Object inputPath : inputPaths) {
            File inputFile = inputPath instanceof Path ? ((Path)inputPath).toFile() : (File)inputPath;
            if (inputFile == null) continue;
            if (inputFile.equals(outputFile)) {
                return new ValidationResult(ValidationResult.Level.ERROR, "Output file cannot be the same as the input file.");
            }
            for (File inputParent = inputFile.getParentFile(); inputParent != null; inputParent = inputParent.getParentFile()) {
                if (!inputParent.equals(outputFile)) continue;
                return new ValidationResult(ValidationResult.Level.ERROR, "Output path must not be a parent of input path.");
            }
            for (File outputParent = outputFile.getParentFile(); outputParent != null; outputParent = outputParent.getParentFile()) {
                if (!outputParent.equals(inputFile)) continue;
                return new ValidationResult(ValidationResult.Level.ERROR, "Input path must not be a parent of output path.");
            }
            nonNullInputFound = true;
        }
        if (!nonNullInputFound) {
            return new ValidationResult(ValidationResult.Level.ERROR, "Input path must be specified.");
        }
        return ValidationResult.SUCCESS;
    }
}

