/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.exec.rulefilters;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.windup.config.RuleProvider;

public class TaggedRuleProviderPredicate
implements Predicate<RuleProvider> {
    private final Set<String> includeTags;
    private final Set<String> excludeTags;
    private boolean requireAllIncludeTags = false;
    private boolean requireAllExcludeTags = false;

    public TaggedRuleProviderPredicate(Collection<String> includeTags, Collection<String> excludeTags) {
        HashSet<String> emptySet = Collections.emptySet();
        this.includeTags = includeTags == null ? emptySet : new HashSet<String>(includeTags);
        this.excludeTags = excludeTags == null ? emptySet : new HashSet<String>(excludeTags);
    }

    public TaggedRuleProviderPredicate setRequireAllIncludeTags(boolean requireAll) {
        this.requireAllIncludeTags = requireAll;
        return this;
    }

    public TaggedRuleProviderPredicate setRequireAllExcludeTags(boolean requireAll) {
        this.requireAllExcludeTags = requireAll;
        return this;
    }

    public boolean accept(RuleProvider provider) {
        Set tags = provider.getMetadata().getTags();
        boolean result = true;
        if (!this.includeTags.isEmpty()) {
            result = this.requireAllIncludeTags ? tags.containsAll(this.includeTags) : CollectionUtils.containsAny((Collection)tags, this.includeTags);
        }
        if (result && !this.excludeTags.isEmpty()) {
            result = this.requireAllExcludeTags ? !tags.containsAll(this.excludeTags) : !CollectionUtils.containsAny((Collection)tags, this.excludeTags);
        }
        return result;
    }

    public String toString() {
        return "TaggedRuleProviderPredicate{incl " + this.includeTags.size() + ", excl" + this.excludeTags.size() + ", requireAllIncl=" + this.requireAllIncludeTags + ", requireAllExcl=" + this.requireAllExcludeTags + '}';
    }
}

