/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.exec.updater;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.DependencyException;
import org.jboss.forge.addon.dependencies.DependencyQuery;
import org.jboss.forge.addon.dependencies.DependencyResolver;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.addon.dependencies.builder.DependencyQueryBuilder;
import org.jboss.forge.addon.maven.resources.MavenModelResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.versions.SingleVersion;
import org.jboss.windup.util.PathUtil;
import org.jboss.windup.util.ZipUtil;
import org.jboss.windup.util.exception.WindupException;

public class RulesetsUpdater {
    private static final Logger LOG = Logger.getLogger(RulesetsUpdater.class.getName());
    private static final String RULESETS_ARTIFACT_ID = "windup-rulesets";
    private static final String RULES_GROUP_ID = "org.jboss.windup.rules";
    public static final String RULESET_CORE_DIRECTORY = "migration-core";
    @Inject
    private Furnace furnace;
    @Inject
    private DependencyResolver depsResolver;
    @Inject
    ResourceFactory factory;

    public boolean rulesetsNeedUpdate(boolean printVersions) {
        return false;
    }

    private SingleVersion getCurrentCoreRulesetsVersion() {
        Path windupRulesDir = this.getRulesetsDir();
        Path coreRulesPomPath = windupRulesDir.resolve("migration-core/META-INF/maven/org.jboss.windup.rules/windup-rulesets/pom.xml");
        File pomXml = coreRulesPomPath.toFile();
        if (!pomXml.exists()) {
            return null;
        }
        MavenModelResource pom = (MavenModelResource)this.factory.create((Object)pomXml);
        return SingleVersion.valueOf((String)pom.getCurrentModel().getVersion());
    }

    public void printRulesetsVersions(SingleVersion installed, SingleVersion latest) {
        String msg = "Core rulesets version: Installed: " + installed + " Latest release: " + latest;
        LOG.info(msg);
        System.out.println(msg);
    }

    public Path getRulesetsDir() {
        Path windupRulesDir = PathUtil.getWindupRulesDir();
        return windupRulesDir;
    }

    public String replaceRulesetsDirectoryWithLatestReleaseIfAny() throws IOException, DependencyException {
        if (!this.rulesetsNeedUpdate(false)) {
            return null;
        }
        Path windupRulesDir = this.getRulesetsDir();
        Path coreRulesetsDir = windupRulesDir.resolve(RULESET_CORE_DIRECTORY);
        Coordinate rulesetsCoord = this.getLatestReleaseOf(RULES_GROUP_ID, RULESETS_ARTIFACT_ID);
        if (rulesetsCoord == null) {
            throw new WindupException("No Windup rulesets release found.");
        }
        FileUtils.deleteDirectory((File)coreRulesetsDir.toFile());
        this.extractArtifact(rulesetsCoord, coreRulesetsDir.toFile());
        return rulesetsCoord.getVersion();
    }

    public void extractArtifact(Coordinate artifactCoords, File targetDir) throws IOException, DependencyException {
        DependencyQueryBuilder query = DependencyQueryBuilder.create((Coordinate)artifactCoords);
        Dependency dependency = this.depsResolver.resolveArtifact((DependencyQuery)query);
        FileResource artifact = dependency.getArtifact();
        ZipUtil.unzipToFolder((File)new File(artifact.getFullyQualifiedName()), (File)targetDir);
    }

    public Coordinate getLatestReleaseOf(String groupId, String artifactId) {
        CoordinateBuilder coord = CoordinateBuilder.create().setGroupId(groupId).setArtifactId(artifactId);
        return this.getLatestReleaseOf(coord);
    }

    public Coordinate getLatestReleaseOf(CoordinateBuilder coord) {
        List availableVersions = this.depsResolver.resolveVersions((DependencyQuery)DependencyQueryBuilder.create((Coordinate)coord));
        for (int i = availableVersions.size() - 1; i >= 0; --i) {
            Coordinate availableCoord = (Coordinate)availableVersions.get(i);
            String versionStr = availableCoord.getVersion();
            if (versionStr == null || availableCoord.isSnapshot() || versionStr.matches(".*CR[0-9]$")) continue;
            return availableCoord;
        }
        return null;
    }

    public Coordinate queryLatestWindupRelease() {
        CoordinateBuilder coords = CoordinateBuilder.create().setGroupId("org.jboss.windup").setArtifactId("windup-distribution").setClassifier("offline").setPackaging("zip");
        Coordinate coord = this.getLatestReleaseOf(coords);
        return coord;
    }

    public String getCurrentRunningWindupVersion() {
        return this.getClass().getPackage().getImplementationVersion();
    }

    private SingleVersion getLatestCoreRulesetVersion() {
        Coordinate lastRelease = this.getLatestReleaseOf(RULES_GROUP_ID, RULESETS_ARTIFACT_ID);
        if (lastRelease == null) {
            return null;
        }
        return new SingleVersion(lastRelease.getVersion());
    }
}

