/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.exec;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.windup.config.DefaultEvaluationContext;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.PreRulesetEvaluation;
import org.jboss.windup.config.RuleLifecycleListener;
import org.jboss.windup.config.RuleSubset;
import org.jboss.windup.config.loader.RuleLoader;
import org.jboss.windup.config.metadata.RuleProviderRegistry;
import org.jboss.windup.config.metadata.TechnologyReference;
import org.jboss.windup.config.metadata.TechnologyReferenceTransformer;
import org.jboss.windup.exec.DefaultRuleLifecycleListener;
import org.jboss.windup.exec.WindupProcessor;
import org.jboss.windup.exec.configuration.WindupConfiguration;
import org.jboss.windup.exec.rulefilters.AndPredicate;
import org.jboss.windup.exec.rulefilters.SourceAndTargetPredicate;
import org.jboss.windup.exec.rulefilters.TaggedRuleProviderPredicate;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.TechnologyReferenceModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.util.Checks;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.config.RuleVisit;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.DefaultParameterValueStore;
import org.ocpsoft.rewrite.param.ParameterValueStore;
import org.ocpsoft.rewrite.util.Visitor;

public class WindupProcessorImpl
implements WindupProcessor {
    private static final Logger LOG = Logging.get(WindupProcessorImpl.class);
    @Inject
    private RuleLoader ruleLoader;
    @Inject
    private Imported<RuleLifecycleListener> listeners;

    public void execute() {
        this.execute(new WindupConfiguration());
    }

    public void execute(WindupConfiguration configuration) {
        long startTime = System.currentTimeMillis();
        this.validateConfig(configuration);
        this.printConfigInfo(configuration);
        GraphContext context = configuration.getGraphContext();
        context.setOptions(configuration.getOptionMap());
        WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)context);
        LinkedHashSet<FileModel> inputPathModels = new LinkedHashSet<FileModel>();
        for (Path inputPath : configuration.getInputPaths()) {
            inputPathModels.add(this.getFileModel(context, inputPath));
        }
        configurationModel.setInputPaths(inputPathModels);
        configurationModel.setOutputPath(this.getFileModel(context, configuration.getOutputDirectory()));
        configurationModel.setOfflineMode(configuration.isOffline());
        configurationModel.setExportingCSV(configuration.isExportingCSV());
        configurationModel.setKeepWorkDirectories((Boolean)configuration.getOptionValue("keepWorkDirs"));
        for (Path path : configuration.getAllUserRulesDirectories()) {
            System.out.println("Using user rules dir: " + path);
            if (path == null) {
                throw new WindupException("Null path found (all paths are: " + configuration.getAllUserRulesDirectories() + ")");
            }
            configurationModel.addUserRulesPath(this.getFileModel(context, path));
        }
        for (Path path : configuration.getAllIgnoreDirectories()) {
            configurationModel.addUserIgnorePath(this.getFileModel(context, path));
        }
        ArrayList<RuleLifecycleListener> listeners = new ArrayList<RuleLifecycleListener>();
        for (RuleLifecycleListener listener : this.listeners) {
            listeners.add(listener);
        }
        final GraphRewrite event = new GraphRewrite(listeners, context);
        this.configureRuleProviderAndTagFilters(event, configuration);
        this.addSourceAndTargetInformation(context, configuration, configurationModel);
        RuleProviderRegistry providerRegistry = this.ruleLoader.loadConfiguration(context, configuration.getRuleProviderFilter());
        Configuration rules = providerRegistry.getConfiguration();
        if (configuration.getProgressMonitor() != null) {
            listeners.add(new DefaultRuleLifecycleListener(configuration.getProgressMonitor(), rules));
        }
        event.getRewriteContext().put(RuleProviderRegistry.class, (Object)providerRegistry);
        RuleSubset ruleSubset = RuleSubset.create((Configuration)rules);
        ruleSubset.setAlwaysHaltOnFailure(configuration.isAlwaysHaltOnException());
        for (RuleLifecycleListener listener : listeners) {
            ruleSubset.addLifecycleListener(listener);
        }
        new RuleVisit((Rule)ruleSubset).accept((Visitor)new Visitor<Rule>(){

            public void visit(Rule r) {
                if (r instanceof PreRulesetEvaluation) {
                    ((PreRulesetEvaluation)r).preRulesetEvaluation(event);
                }
            }
        });
        ruleSubset.perform((Rewrite)event, this.createEvaluationContext());
        long endTime = System.currentTimeMillis();
        long seconds = (endTime - startTime) / 1000L;
        LOG.info("Windup execution took " + seconds + " seconds to execute on input: " + configuration.getInputPaths() + "!");
        ExecutionStatistics.get().reset();
    }

    private void addSourceAndTargetInformation(GraphContext context, WindupConfiguration configuration, WindupConfigurationModel configurationModel) {
        Collection sources = (Collection)configuration.getOptionMap().get("source");
        Collection targets = (Collection)configuration.getOptionMap().get("target");
        GraphService technologyReferenceService = new GraphService(context, TechnologyReferenceModel.class);
        if (sources != null) {
            for (String sourceID : sources) {
                configurationModel.addSourceTechnology(this.getTechnologyReferenceModelWithVersion((GraphService<TechnologyReferenceModel>)technologyReferenceService, sourceID));
            }
        }
        if (targets != null) {
            for (String targetID : targets) {
                configurationModel.addTargetTechnology(this.getTechnologyReferenceModelWithVersion((GraphService<TechnologyReferenceModel>)technologyReferenceService, targetID));
            }
        }
    }

    private TechnologyReferenceModel getTechnologyReferenceModelWithVersion(GraphService<TechnologyReferenceModel> service, String technologyID) {
        TechnologyReference reference = TechnologyReference.parseFromIDAndVersion((String)technologyID);
        TechnologyReferenceModel technologyReferenceModel = (TechnologyReferenceModel)service.create();
        technologyReferenceModel.setTechnologyID(reference.getId());
        technologyReferenceModel.setVersionRange(reference.getVersionRangeAsString());
        return technologyReferenceModel;
    }

    private void configureRuleProviderAndTagFilters(GraphRewrite event, WindupConfiguration config) {
        Collection includeTags = (Collection)config.getOptionMap().get("includeTags");
        Collection excludeTags = (Collection)config.getOptionMap().get("excludeTags");
        Collection<String> sources = (Collection<String>)config.getOptionMap().get("source");
        Collection<String> targets = (Collection<String>)config.getOptionMap().get("target");
        if (includeTags != null && includeTags.isEmpty()) {
            includeTags = null;
        }
        if (excludeTags != null && excludeTags.isEmpty()) {
            excludeTags = null;
        }
        if (sources != null && sources.isEmpty()) {
            sources = null;
        }
        if (targets != null && targets.isEmpty()) {
            targets = null;
        }
        if (includeTags != null || excludeTags != null || sources != null || targets != null) {
            Predicate configuredPredicate = config.getRuleProviderFilter();
            TaggedRuleProviderPredicate tagPredicate = new TaggedRuleProviderPredicate(includeTags, excludeTags);
            List transformers = TechnologyReferenceTransformer.getTransformers((GraphRewrite)event);
            HashMap<String, List<TechnologyReferenceTransformer>> transformerMap = new HashMap<String, List<TechnologyReferenceTransformer>>();
            for (TechnologyReferenceTransformer transformer : transformers) {
                String transformerID = transformer.getOriginal().getId();
                if (transformerMap.containsKey(transformerID)) {
                    List existingList = (List)transformerMap.get(transformerID);
                    existingList.add(transformer);
                    continue;
                }
                ArrayList<TechnologyReferenceTransformer> newList = new ArrayList<TechnologyReferenceTransformer>();
                newList.add(transformer);
                transformerMap.put(transformerID, newList);
            }
            sources = this._transformTechnologyReference(sources, transformerMap);
            config.setOptionValue("source", sources);
            targets = this._transformTechnologyReference(targets, transformerMap);
            config.setOptionValue("target", targets);
            SourceAndTargetPredicate sourceAndTargetPredicate = new SourceAndTargetPredicate(sources, targets);
            AndPredicate providerFilter = new AndPredicate(new Predicate[]{tagPredicate, sourceAndTargetPredicate});
            if (configuredPredicate != null) {
                providerFilter = new AndPredicate(new Predicate[]{configuredPredicate, tagPredicate, sourceAndTargetPredicate});
            }
            LOG.info("RuleProvider filter: " + providerFilter);
            config.setRuleProviderFilter((Predicate)providerFilter);
        }
    }

    private Collection<String> _transformTechnologyReference(Collection<String> targets, Map<String, List<TechnologyReferenceTransformer>> transformerMap) {
        if (targets != null) {
            HashSet<String> newTargets = new HashSet<String>();
            for (String target : targets) {
                newTargets.add(this.transformReferenceTechnology(transformerMap, target));
            }
            targets = newTargets;
        }
        return targets;
    }

    private String transformReferenceTechnology(Map<String, List<TechnologyReferenceTransformer>> transformerMap, String technologyID) {
        if (transformerMap.containsKey(technologyID)) {
            for (TechnologyReferenceTransformer transformer : transformerMap.get(TechnologyReference.parseFromIDAndVersion((String)technologyID).getId())) {
                technologyID = transformer.transform(technologyID).toString();
            }
        }
        return technologyID;
    }

    private FileModel getFileModel(GraphContext context, Path file) {
        return new FileService(context).createByFilePath(file.toString());
    }

    private EvaluationContext createEvaluationContext() {
        DefaultEvaluationContext evaluationContext = new DefaultEvaluationContext();
        DefaultParameterValueStore values = new DefaultParameterValueStore();
        evaluationContext.put(ParameterValueStore.class, (Object)values);
        return evaluationContext;
    }

    private void validateConfig(WindupConfiguration windupConfiguration) {
        Assert.notNull((Object)windupConfiguration, (String)"Windup configuration must not be null. (Call default execution if no configuration is required.)");
        GraphContext context = windupConfiguration.getGraphContext();
        Assert.notNull((Object)context, (String)"Windup GraphContext must not be null!");
        Collection inputPaths = windupConfiguration.getInputPaths();
        Assert.notNull((Object)inputPaths, (String)"Path to the application must not be null!");
        for (Path inputPath : inputPaths) {
            Assert.notNull((Object)inputPath, (String)"Path to the application must not be null!");
            Checks.checkFileOrDirectoryToBeRead((File)inputPath.toFile(), (String)"Application");
        }
        Path outputDirectory = windupConfiguration.getOutputDirectory();
        Assert.notNull((Object)outputDirectory, (String)"Output directory must not be null!");
        Checks.checkDirectoryToBeFilled((File)outputDirectory.toFile(), (String)"Output directory");
    }

    private void printConfigInfo(WindupConfiguration windupConfiguration) {
        LOG.info("");
        if (windupConfiguration.getInputPaths().size() == 1) {
            LOG.info("Input Application:" + windupConfiguration.getInputPaths().iterator().next());
        } else {
            LOG.info("Input Applications:");
            for (Path path : windupConfiguration.getInputPaths()) {
                LOG.info("\t" + path);
            }
            LOG.info("");
        }
        LOG.info("Output Path:" + windupConfiguration.getOutputDirectory());
        LOG.info("");
        for (Map.Entry entry : windupConfiguration.getOptionMap().entrySet()) {
            LOG.info("\t" + (String)entry.getKey() + ": " + entry.getValue());
        }
    }
}

