/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.exec;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.windup.config.DefaultEvaluationContext;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.PreRulesetEvaluation;
import org.jboss.windup.config.RuleLifecycleListener;
import org.jboss.windup.config.RuleSubset;
import org.jboss.windup.config.loader.RuleLoader;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleProviderRegistry;
import org.jboss.windup.config.metadata.TechnologyReference;
import org.jboss.windup.config.metadata.TechnologyReferenceTransformer;
import org.jboss.windup.config.phase.PostReportGenerationPhase;
import org.jboss.windup.config.phase.PostReportRenderingPhase;
import org.jboss.windup.config.phase.PreReportGenerationPhase;
import org.jboss.windup.config.phase.ReportGenerationPhase;
import org.jboss.windup.config.phase.ReportRenderingPhase;
import org.jboss.windup.exec.DefaultRuleLifecycleListener;
import org.jboss.windup.exec.WindupProcessor;
import org.jboss.windup.exec.configuration.WindupConfiguration;
import org.jboss.windup.exec.rulefilters.AndPredicate;
import org.jboss.windup.exec.rulefilters.NotPredicate;
import org.jboss.windup.exec.rulefilters.RuleProviderPhasePredicate;
import org.jboss.windup.exec.rulefilters.SourceAndTargetPredicate;
import org.jboss.windup.exec.rulefilters.TaggedRuleProviderPredicate;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphContextFactory;
import org.jboss.windup.graph.model.TechnologyReferenceModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.util.Checks;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.config.RuleVisit;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.DefaultParameterValueStore;
import org.ocpsoft.rewrite.param.ParameterValueStore;

public class WindupProcessorImpl
implements WindupProcessor {
    private static final Logger LOG = Logging.get(WindupProcessorImpl.class);
    @Inject
    private RuleLoader ruleLoader;
    @Inject
    private GraphContextFactory graphContextFactory;
    @Inject
    private Imported<RuleLifecycleListener> listeners;

    public void execute() {
        this.execute(new WindupConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(WindupConfiguration configuration) {
        long startTime = System.currentTimeMillis();
        this.validateConfig(configuration);
        boolean autoCloseGraph = false;
        if (configuration.getGraphContext() == null) {
            autoCloseGraph = true;
            Path graphPath = configuration.getOutputDirectory().resolve("graph");
            GraphContext graphContext = this.graphContextFactory.create(graphPath);
            configuration.setGraphContext(graphContext);
        }
        try {
            this.printConfigInfo(configuration);
            GraphContext context = configuration.getGraphContext();
            context.setOptions(configuration.getOptionMap());
            WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)context);
            LinkedHashSet<FileModel> inputPathModels = new LinkedHashSet<FileModel>();
            for (Path inputPath : configuration.getInputPaths()) {
                inputPathModels.add(this.getFileModel(context, inputPath));
            }
            configurationModel.setInputPaths(inputPathModels);
            configurationModel.setOutputPath(this.getFileModel(context, configuration.getOutputDirectory()));
            configurationModel.setOfflineMode(configuration.isOffline());
            configurationModel.setExportingCSV(configuration.isExportingCSV());
            configurationModel.setKeepWorkDirectories((Boolean)configuration.getOptionValue("keepWorkDirs"));
            for (Object path : configuration.getAllUserRulesDirectories()) {
                System.out.println("Using user rules dir: " + path);
                if (path == null) {
                    throw new WindupException("Null path found (all paths are: " + configuration.getAllUserRulesDirectories() + ")");
                }
                configurationModel.addUserRulesPath(this.getFileModel(context, (Path)path));
            }
            for (Object path : configuration.getAllIgnoreDirectories()) {
                configurationModel.addUserIgnorePath(this.getFileModel(context, (Path)path));
            }
            ArrayList<RuleLifecycleListener> listeners = new ArrayList<RuleLifecycleListener>();
            for (RuleLifecycleListener listener : this.listeners) {
                listeners.add(listener);
            }
            GraphRewrite event = new GraphRewrite(listeners, context);
            RuleLoaderContext ruleLoaderContext = new RuleLoaderContext(configuration.getAllUserRulesDirectories(), configuration.getRuleProviderFilter());
            ruleLoaderContext = this.configureRuleProviderAndTagFilters(ruleLoaderContext, configuration);
            this.addSourceAndTargetInformation(event, configuration, configurationModel);
            RuleProviderRegistry providerRegistry = this.ruleLoader.loadConfiguration(ruleLoaderContext);
            Configuration rules = providerRegistry.getConfiguration();
            if (configuration.getProgressMonitor() != null) {
                listeners.add(new DefaultRuleLifecycleListener(configuration.getProgressMonitor(), rules));
            }
            event.getRewriteContext().put(RuleProviderRegistry.class, (Object)providerRegistry);
            RuleSubset ruleSubset = RuleSubset.create((Configuration)rules);
            ruleSubset.setAlwaysHaltOnFailure(configuration.isAlwaysHaltOnException());
            for (RuleLifecycleListener listener : listeners) {
                ruleSubset.addLifecycleListener(listener);
            }
            new RuleVisit((Rule)ruleSubset).accept(rule -> {
                if (rule instanceof PreRulesetEvaluation) {
                    ((PreRulesetEvaluation)rule).preRulesetEvaluation(event);
                }
            });
            ruleSubset.perform((Rewrite)event, this.createEvaluationContext());
        }
        finally {
            if (autoCloseGraph) {
                try {
                    configuration.getGraphContext().close();
                }
                catch (Throwable t) {
                    LOG.log(Level.WARNING, "Failed to close graph due to: " + t.getMessage(), t);
                }
            }
            long endTime = System.currentTimeMillis();
            long seconds = (endTime - startTime) / 1000L;
            LOG.info("Windup execution took " + seconds + " seconds to execute on input: " + configuration.getInputPaths() + "!");
            ExecutionStatistics.get().reset();
        }
    }

    private void addSourceAndTargetInformation(GraphRewrite event, WindupConfiguration configuration, WindupConfigurationModel configurationModel) {
        Collection sources = (Collection)configuration.getOptionMap().get("source");
        Collection targets = (Collection)configuration.getOptionMap().get("target");
        GraphService technologyReferenceService = new GraphService(event.getGraphContext(), TechnologyReferenceModel.class);
        Function<String, TechnologyReferenceModel> createReferenceModel = techID -> {
            TechnologyReference reference = TechnologyReference.parseFromIDAndVersion((String)techID);
            TechnologyReferenceModel technologyReferenceModel = (TechnologyReferenceModel)technologyReferenceService.create();
            technologyReferenceModel.setTechnologyID(reference.getId());
            technologyReferenceModel.setVersionRange(reference.getVersionRangeAsString());
            return technologyReferenceModel;
        };
        if (sources != null) {
            sources.forEach(sourceID -> configurationModel.addSourceTechnology((TechnologyReferenceModel)createReferenceModel.apply((String)sourceID)));
        }
        if (targets != null) {
            targets.forEach(targetID -> configurationModel.addTargetTechnology((TechnologyReferenceModel)createReferenceModel.apply((String)targetID)));
        }
    }

    private RuleLoaderContext configureRuleProviderAndTagFilters(RuleLoaderContext ruleLoaderContext, WindupConfiguration config) {
        Collection includeTags = (Collection)config.getOptionMap().get("includeTags");
        Collection excludeTags = (Collection)config.getOptionMap().get("excludeTags");
        Collection sources = (Collection)config.getOptionMap().get("source");
        Collection targets = (Collection)config.getOptionMap().get("target");
        if (includeTags != null && includeTags.isEmpty()) {
            includeTags = null;
        }
        if (excludeTags != null && excludeTags.isEmpty()) {
            excludeTags = null;
        }
        if (sources != null && sources.isEmpty()) {
            sources = null;
        }
        if (targets != null && targets.isEmpty()) {
            targets = null;
        }
        if (includeTags != null || excludeTags != null || sources != null || targets != null) {
            Predicate configuredPredicate = config.getRuleProviderFilter();
            TaggedRuleProviderPredicate tagPredicate = new TaggedRuleProviderPredicate(includeTags, excludeTags);
            List transformers = TechnologyReferenceTransformer.getTransformers((RuleLoaderContext)ruleLoaderContext);
            Map<String, List> transformerMap = transformers.stream().collect(Collectors.toMap(transformer -> transformer.getOriginal().getId(), transformer -> {
                ArrayList<TechnologyReferenceTransformer> list = new ArrayList<TechnologyReferenceTransformer>();
                list.add((TechnologyReferenceTransformer)transformer);
                return list;
            }, (old, latest) -> {
                old.addAll(latest);
                return old;
            }));
            Function<String, String> transformTechFunction = technologyID -> {
                if (transformerMap.containsKey(technologyID)) {
                    for (TechnologyReferenceTransformer transformer : (List)transformerMap.get(TechnologyReference.parseFromIDAndVersion((String)technologyID).getId())) {
                        technologyID = transformer.transform(technologyID).toString();
                    }
                }
                return technologyID;
            };
            sources = sources == null ? null : (Collection)sources.stream().map(transformTechFunction).collect(Collectors.toSet());
            config.setOptionValue("source", (Object)sources);
            targets = targets == null ? null : (Collection)targets.stream().map(transformTechFunction).collect(Collectors.toSet());
            config.setOptionValue("target", (Object)targets);
            SourceAndTargetPredicate sourceAndTargetPredicate = new SourceAndTargetPredicate(sources, targets);
            AndPredicate providerFilter = new AndPredicate(new Predicate[]{tagPredicate, sourceAndTargetPredicate});
            if (configuredPredicate != null) {
                providerFilter = new AndPredicate(new Predicate[]{configuredPredicate, tagPredicate, sourceAndTargetPredicate});
            }
            LOG.info("RuleProvider filter: " + providerFilter);
            config.setRuleProviderFilter((Predicate)providerFilter);
        }
        Boolean skipReports = false;
        if (config.getOptionMap().containsKey("skipReports")) {
            skipReports = (Boolean)config.getOptionMap().get("skipReports");
        }
        if (skipReports.booleanValue()) {
            NotPredicate skipReportsProviderFilter = new NotPredicate((Predicate)new RuleProviderPhasePredicate(new Class[]{PreReportGenerationPhase.class, ReportGenerationPhase.class, ReportRenderingPhase.class, PostReportGenerationPhase.class, PostReportRenderingPhase.class}));
            Predicate configuredProvider = config.getRuleProviderFilter();
            AndPredicate providerFilter = new AndPredicate(new Predicate[]{skipReportsProviderFilter});
            if (configuredProvider != null) {
                providerFilter = new AndPredicate(new Predicate[]{configuredProvider, skipReportsProviderFilter});
            }
            LOG.info("Adding RuleProvider filter for skipping reports: " + providerFilter);
            config.setRuleProviderFilter((Predicate)providerFilter);
        }
        return new RuleLoaderContext(ruleLoaderContext.getRulePaths(), config.getRuleProviderFilter());
    }

    private FileModel getFileModel(GraphContext context, Path file) {
        return new FileService(context).createByFilePath(file.toString());
    }

    private EvaluationContext createEvaluationContext() {
        DefaultEvaluationContext evaluationContext = new DefaultEvaluationContext();
        DefaultParameterValueStore values = new DefaultParameterValueStore();
        evaluationContext.put(ParameterValueStore.class, (Object)values);
        return evaluationContext;
    }

    private void validateConfig(WindupConfiguration windupConfiguration) {
        Assert.notNull((Object)windupConfiguration, (String)"Windup configuration must not be null. (Call default execution if no configuration is required.)");
        Collection inputPaths = windupConfiguration.getInputPaths();
        Assert.notNull((Object)inputPaths, (String)"Path to the application must not be null!");
        for (Path inputPath : inputPaths) {
            Assert.notNull((Object)inputPath, (String)"Path to the application must not be null!");
            Checks.checkFileOrDirectoryToBeRead((File)inputPath.toFile(), (String)"Application");
        }
        Path outputDirectory = windupConfiguration.getOutputDirectory();
        Assert.notNull((Object)outputDirectory, (String)"Output directory must not be null!");
        Checks.checkDirectoryToBeFilled((File)outputDirectory.toFile(), (String)"Output directory");
    }

    private void printConfigInfo(WindupConfiguration windupConfiguration) {
        LOG.info("");
        if (windupConfiguration.getInputPaths().size() == 1) {
            LOG.info("Input Application:" + windupConfiguration.getInputPaths().iterator().next());
        } else {
            LOG.info("Input Applications:");
            for (Path path : windupConfiguration.getInputPaths()) {
                LOG.info("\t" + path);
            }
            LOG.info("");
        }
        LOG.info("Output Path:" + windupConfiguration.getOutputDirectory());
        LOG.info("");
        for (Map.Entry entry : windupConfiguration.getOptionMap().entrySet()) {
            LOG.info("\t" + (String)entry.getKey() + ": " + entry.getValue());
        }
    }
}

