/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.archives.identify;

import java.io.File;
import java.util.logging.Logger;
import org.apache.lucene.document.Document;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.windup.maven.nexusindexer.client.DocTo;
import org.jboss.windup.maven.nexusindexer.client.LuceneIndexServiceBase;
import org.jboss.windup.rules.apps.java.archives.identify.ArchiveIdentificationService;
import org.jboss.windup.util.Logging;

public class LuceneArchiveIdentificationService
extends LuceneIndexServiceBase
implements ArchiveIdentificationService {
    private static final Logger LOG = Logging.get(LuceneArchiveIdentificationService.class);
    private static final String SHA1 = "sha1";
    private static final String GROUP_ID = "groupId";
    private static final String ARTIFACT_ID = "artifactId";
    private static final String PACKAGING = "packaging";
    private static final String CLASSIFIER = "classifier";
    private static final String VERSION = "version";

    public LuceneArchiveIdentificationService(File directory) {
        super(directory);
    }

    @Override
    public Coordinate getCoordinate(String sha1) {
        return (Coordinate)this.findSingle(SHA1, sha1, (DocTo)new DocTo<Coordinate>(){

            public Coordinate convert(Document doc) {
                return CoordinateBuilder.create().setGroupId(doc.get(LuceneArchiveIdentificationService.GROUP_ID)).setArtifactId(doc.get(LuceneArchiveIdentificationService.ARTIFACT_ID)).setVersion(doc.get(LuceneArchiveIdentificationService.VERSION)).setClassifier(doc.get(LuceneArchiveIdentificationService.CLASSIFIER)).setPackaging(doc.get(LuceneArchiveIdentificationService.PACKAGING));
            }
        });
    }
}

