/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.jboss.tattletale.reporting.Filter;
import org.jboss.tattletale.reporting.SizeComparator;

public class KeyValueFilter
implements Filter {
    private Map<String, SortedSet<String>> keyValueFilters = new HashMap<String, SortedSet<String>>();

    public boolean isFiltered() {
        throw new UnsupportedOperationException("isFiltered() not supported");
    }

    public boolean isFiltered(String archive) {
        throw new UnsupportedOperationException("isFiltered(String) not supported");
    }

    public boolean isFiltered(String archive, String query) {
        SortedSet<String> ss = this.keyValueFilters.get(archive);
        if (ss != null) {
            if (query.endsWith(".class")) {
                query = query.substring(0, query.indexOf(".class"));
            }
            if (query.endsWith(".jar")) {
                query = query.substring(0, query.indexOf(".jar"));
            }
            if (query.endsWith(".*")) {
                query = query.substring(0, query.indexOf(".*"));
            }
            query = query.replace('.', '/');
            for (String v : ss) {
                if (!query.startsWith(v)) continue;
                return true;
            }
        }
        return false;
    }

    public void init(String filter) {
        if (filter != null) {
            StringTokenizer st = new StringTokenizer(filter, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int equal = token.indexOf("=");
                String key = token.substring(0, equal);
                String values = token.substring(equal + 1);
                TreeSet<String> v = new TreeSet<String>(new SizeComparator());
                StringTokenizer vt = new StringTokenizer(values, ",");
                while (vt.hasMoreTokens()) {
                    String value = vt.nextToken();
                    boolean includeAll = false;
                    if (value.endsWith(".class")) {
                        value = value.substring(0, value.indexOf(".class"));
                    }
                    if (value.endsWith(".jar")) {
                        value = value.substring(0, value.indexOf(".jar"));
                    }
                    if (value.endsWith(".*")) {
                        value = value.substring(0, value.indexOf(".*"));
                        includeAll = true;
                    }
                    value = value.replace('.', '/');
                    if (includeAll) {
                        value = value + '/';
                    }
                    v.add(value);
                }
                this.keyValueFilters.put(key, v);
            }
        }
    }
}

