/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.reporting.freemarker;

import freemarker.template.SimpleScalar;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.rules.apps.java.model.AbstractJavaSourceModel;
import org.jboss.windup.rules.apps.java.model.AmbiguousJavaClassModel;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;
import org.jboss.windup.rules.apps.java.service.JavaClassService;

public class FindSourceFilesByClassNameMethod
implements WindupFreeMarkerMethod {
    private JavaClassService javaClassService;

    public Object exec(List arguments) throws TemplateModelException {
        if (arguments.size() != 1) {
            throw new TemplateModelException("Error, method expects one argument (String)");
        }
        SimpleScalar arg = (SimpleScalar)arguments.get(0);
        String qualifedClassName = arg.getAsString();
        JavaClassModel classModel = this.javaClassService.getByName(qualifedClassName);
        ArrayList<AbstractJavaSourceModel> results = new ArrayList<AbstractJavaSourceModel>();
        if (classModel instanceof AmbiguousJavaClassModel) {
            AmbiguousJavaClassModel ambiguousJavaClassModel = (AmbiguousJavaClassModel)classModel;
            for (JavaClassModel referencedClass : ambiguousJavaClassModel.getReferences()) {
                this.addSourceFilesToResult(results, referencedClass);
            }
        } else {
            this.addSourceFilesToResult(results, classModel);
        }
        return results;
    }

    private void addSourceFilesToResult(List<AbstractJavaSourceModel> results, JavaClassModel referencedClass) {
        JavaSourceFileModel decompiledSource = referencedClass.getDecompiledSource();
        AbstractJavaSourceModel originalSource = referencedClass.getOriginalSource();
        if (decompiledSource != null) {
            results.add(decompiledSource);
        }
        if (originalSource != null) {
            results.add(originalSource);
        }
    }

    public String getDescription() {
        return "Finds all " + JavaSourceFileModel.class.getSimpleName() + "s for the given fully qualified class name";
    }

    public void setContext(GraphRewrite event) {
        this.javaClassService = new JavaClassService(event.getGraphContext());
    }
}

