/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.operation;

import java.io.File;
import java.io.FileFilter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.util.Logging;

public class IdentifiedArchiveFileFilter
implements FileFilter {
    private static final Logger LOG = Logging.get(IdentifiedArchiveFileFilter.class);
    private final String archiveName;

    public IdentifiedArchiveFileFilter(ArchiveModel archive) {
        this.archiveName = archive.getArchiveName();
    }

    @Override
    public boolean accept(File file) {
        if (file.isFile()) {
            if (StringUtils.equals((CharSequence)file.getName(), (CharSequence)"MANIFEST.MF") || StringUtils.equals((CharSequence)file.getName(), (CharSequence)"pom.xml") || StringUtils.equals((CharSequence)file.getName(), (CharSequence)"pom.properties") || StringUtils.containsIgnoreCase((CharSequence)file.getName(), (CharSequence)"license") || StringUtils.containsIgnoreCase((CharSequence)file.getName(), (CharSequence)"notice") || StringUtils.containsIgnoreCase((CharSequence)file.getName(), (CharSequence)"lgpl") || StringUtils.containsIgnoreCase((CharSequence)file.getName(), (CharSequence)"gpl")) {
                LOG.info(this.archiveName + " - Accepting File on Identified Archive: " + file.getName() + ".");
                return true;
            }
            if (LOG.getLevel() == Level.FINE) {
                LOG.fine(this.archiveName + " - Rejecting File on Identified Archive: " + file.getName() + ".");
            }
            return false;
        }
        return true;
    }
}

