/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.operation;

import com.thinkaurelius.titan.core.TitanGraph;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.DuplicateArchiveModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.IgnoredFileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.rules.apps.java.archives.model.IdentifiedArchiveModel;
import org.jboss.windup.rules.apps.java.scan.operation.IdentifiedArchiveFileFilter;
import org.jboss.windup.rules.apps.java.service.WindupJavaConfigurationService;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.ZipUtil;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class UnzipArchiveToOutputFolder
extends AbstractIterationOperation<ArchiveModel> {
    private static final String MALFORMED_ARCHIVE = "Malformed archive";
    private static final String ARCHIVES = "archives";
    private static final Logger LOG = Logging.get(UnzipArchiveToOutputFolder.class);

    public static UnzipArchiveToOutputFolder unzip() {
        return new UnzipArchiveToOutputFolder();
    }

    public void perform(GraphRewrite event, EvaluationContext context, ArchiveModel payload) {
        LOG.info("Unzipping archive: " + payload.toPrettyString());
        File zipFile = payload.asFile();
        if (zipFile == null || !zipFile.isFile()) {
            throw new WindupException("Input path doesn't point to a file: " + (zipFile == null ? "null" : zipFile.getAbsolutePath()));
        }
        GraphContext graphContext = event.getGraphContext();
        Path unzippedArchiveDir = UnzipArchiveToOutputFolder.getArchivesDirLocation(graphContext);
        UnzipArchiveToOutputFolder.ensureDirIsCreated(unzippedArchiveDir);
        this.unzipToTempDirectory(event, context, unzippedArchiveDir, zipFile, payload, false);
    }

    public static Path getArchivesDirLocation(GraphContext graphContext) {
        WindupConfigurationModel cfg = WindupConfigurationService.getConfigurationModel((GraphContext)graphContext);
        String windupOutputFolder = cfg.getOutputPath().getFilePath();
        return Paths.get(windupOutputFolder, ARCHIVES);
    }

    private void unzipToTempDirectory(GraphRewrite event, EvaluationContext context, Path tempFolder, File inputZipFile, ArchiveModel archiveModel, boolean subArchivesOnly) {
        FileService fileService = new FileService(event.getGraphContext());
        String appArchiveName = archiveModel.getArchiveName();
        if (null == appArchiveName) {
            throw new IllegalStateException("Archive model doesn't have an archiveName: " + archiveModel.getFilePath());
        }
        Path appArchiveFolder = UnzipArchiveToOutputFolder.getNonexistentDirForAppArchive(tempFolder, appArchiveName);
        UnzipArchiveToOutputFolder.ensureDirIsCreated(appArchiveFolder);
        LOG.info("Unzipping " + inputZipFile.getPath() + " to " + appArchiveFolder.toString());
        try {
            ZipUtil.unzipToFolder((File)inputZipFile, (File)appArchiveFolder.toFile());
        }
        catch (Throwable e) {
            ArchiveModel canonicalArchive = archiveModel;
            if (canonicalArchive instanceof DuplicateArchiveModel) {
                canonicalArchive = ((DuplicateArchiveModel)canonicalArchive).getCanonicalArchive();
            }
            ClassificationService classificationService = new ClassificationService(event.getGraphContext());
            classificationService.attachClassification(event, context, (FileModel)canonicalArchive, MALFORMED_ARCHIVE, "Cannot unzip the file");
            archiveModel.setParseError("Cannot unzip the file: " + e.getMessage());
            LOG.warning("Cannot unzip the file " + inputZipFile.getPath() + " to " + appArchiveFolder.toString() + ". The ArchiveModel was classified as malformed.");
            return;
        }
        archiveModel.setUnzippedDirectory(appArchiveFolder.toString());
        this.recurseAndAddFiles(event, context, tempFolder, fileService, archiveModel, (FileModel)archiveModel, subArchivesOnly);
    }

    private void recurseAndAddFiles(GraphRewrite event, EvaluationContext context, Path tempFolder, FileService fileService, ArchiveModel archiveModel, FileModel parentFileModel, boolean subArchivesOnly) {
        int numberAdded = 0;
        Object filter = TrueFileFilter.TRUE;
        if (archiveModel instanceof IdentifiedArchiveModel) {
            filter = new IdentifiedArchiveFileFilter(archiveModel);
        }
        File fileReference = parentFileModel instanceof ArchiveModel ? new File(((ArchiveModel)parentFileModel).getUnzippedDirectory()) : parentFileModel.asFile();
        WindupJavaConfigurationService windupJavaConfigurationService = new WindupJavaConfigurationService(event.getGraphContext());
        File[] subFiles = fileReference.listFiles();
        if (subFiles == null) {
            return;
        }
        for (File subFile : subFiles) {
            FileModel subFileModel;
            if (!filter.accept(subFile) || subArchivesOnly && !ZipUtil.endsWithZipExtension((String)subFile.getAbsolutePath()) || this.checkIfIgnored(event, subFileModel = fileService.createByFilePath(parentFileModel, subFile.getAbsolutePath()), windupJavaConfigurationService.getIgnoredFileRegexes())) continue;
            if (++numberAdded % 250 == 0) {
                ((TitanGraph)event.getGraphContext().getGraph().getBaseGraph()).commit();
            }
            if (subFile.isFile() && ZipUtil.endsWithZipExtension((String)subFileModel.getFilePath())) {
                File newZipFile = subFileModel.asFile();
                ArchiveModel newArchiveModel = (ArchiveModel)GraphService.addTypeToModel((GraphContext)event.getGraphContext(), (WindupVertexFrame)subFileModel, ArchiveModel.class);
                newArchiveModel.setParentArchive(archiveModel);
                newArchiveModel.setArchiveName(newZipFile.getName());
                newArchiveModel = (ArchiveModel)GraphService.refresh((GraphContext)event.getGraphContext(), (WindupVertexFrame)newArchiveModel);
                ArchiveModel canonicalArchiveModel = null;
                for (FileModel otherMatches : fileService.findAllByProperty("sha1Hash", (Object)newArchiveModel.getSHA1Hash())) {
                    if (!(otherMatches instanceof ArchiveModel) || otherMatches.equals(newArchiveModel) || otherMatches instanceof DuplicateArchiveModel) continue;
                    canonicalArchiveModel = (ArchiveModel)otherMatches;
                    break;
                }
                if (canonicalArchiveModel != null) {
                    DuplicateArchiveModel duplicateArchive = (DuplicateArchiveModel)GraphService.addTypeToModel((GraphContext)event.getGraphContext(), (WindupVertexFrame)newArchiveModel, DuplicateArchiveModel.class);
                    duplicateArchive.setCanonicalArchive(canonicalArchiveModel);
                    this.unzipToTempDirectory(event, context, tempFolder, newZipFile, (ArchiveModel)duplicateArchive, true);
                    continue;
                }
                this.unzipToTempDirectory(event, context, tempFolder, newZipFile, newArchiveModel, false);
                continue;
            }
            if (!subFile.isDirectory()) continue;
            this.recurseAndAddFiles(event, context, tempFolder, fileService, archiveModel, subFileModel, false);
        }
    }

    private boolean checkIfIgnored(GraphRewrite event, FileModel file, List<String> patterns) {
        boolean ignored = false;
        if (patterns != null && !patterns.isEmpty()) {
            for (String pattern : patterns) {
                if (!file.getFilePath().matches(pattern)) continue;
                IgnoredFileModel ignoredFileModel = (IgnoredFileModel)GraphService.addTypeToModel((GraphContext)event.getGraphContext(), (WindupVertexFrame)file, IgnoredFileModel.class);
                ignoredFileModel.setIgnoredRegex(pattern);
                LOG.info("File/Directory placed in " + file.getFilePath() + " was ignored, because matched [" + pattern + "].");
                ignored = true;
                break;
            }
        }
        return ignored;
    }

    private static Path getNonexistentDirForAppArchive(Path tempFolder, String appArchiveName) {
        Path appArchiveFolder = Paths.get(tempFolder.toString(), appArchiveName);
        int fileIdx = 1;
        while (Files.exists(appArchiveFolder, new LinkOption[0])) {
            appArchiveFolder = Paths.get(tempFolder.toString(), appArchiveName + "." + fileIdx);
            ++fileIdx;
        }
        return appArchiveFolder;
    }

    private static void ensureDirIsCreated(Path windupTempUnzippedArchiveFolder) throws WindupException {
        if (!Files.isDirectory(windupTempUnzippedArchiveFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(windupTempUnzippedArchiveFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new WindupException("Failed to create temporary folder for archives: " + windupTempUnzippedArchiveFolder + "\n\tdue to: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public String toString() {
        return UnzipArchiveToOutputFolder.class.getSimpleName();
    }
}

