/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.provider;

import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.DiscoverProjectStructurePhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.rules.apps.java.model.JarManifestModel;
import org.jboss.windup.rules.apps.java.scan.provider.DiscoverNonMavenArchiveProjectsRuleProvider;
import org.jboss.windup.rules.apps.java.service.JarManifestService;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=DiscoverProjectStructurePhase.class, after={DiscoverNonMavenArchiveProjectsRuleProvider.class})
public class DiscoverAdditionalProjectDetails
extends AbstractRuleProvider {
    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.fromType(ArchiveModel.class)).perform((Operation)new AbstractIterationOperation<ArchiveModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, ArchiveModel payload) {
                DiscoverAdditionalProjectDetails.this.getAdditionalProjectDetails(event.getGraphContext(), payload);
            }
        });
    }

    private void getAdditionalProjectDetails(GraphContext context, ArchiveModel archiveModel) {
        ProjectModel projectModel = archiveModel.getProjectModel();
        if (projectModel == null) {
            return;
        }
        JarManifestService service = new JarManifestService(context);
        Iterable<JarManifestModel> manifests = service.getManifestsByArchive(archiveModel);
        for (JarManifestModel manifest : manifests) {
            if (StringUtils.isNotBlank((CharSequence)manifest.getName()) && (projectModel.getName() == null || projectModel.getName().equals(archiveModel.getArchiveName()))) {
                projectModel.setName(manifest.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)manifest.getVendor()) && StringUtils.isBlank((CharSequence)projectModel.getOrganization())) {
                projectModel.setOrganization(manifest.getVendor());
            }
            if (StringUtils.isNotBlank((CharSequence)manifest.getVersion()) && StringUtils.isBlank((CharSequence)projectModel.getVersion())) {
                projectModel.setVersion(manifest.getVersion());
            }
            if (!StringUtils.isNotBlank((CharSequence)manifest.getDescription()) || !StringUtils.isBlank((CharSequence)projectModel.getDescription())) continue;
            projectModel.setDescription(manifest.getDescription());
        }
    }
}

