/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.reflection.Type;
import com.strobel.reflection.TypeList;
import com.strobel.util.TypeUtils;

public final class SignatureType {
    private final Type<?> _returnType;
    private final TypeList _parameterTypes;
    private SignatureType _erasedSignature;

    public SignatureType(Type<?> returnType, TypeList parameterTypes) {
        this._returnType = returnType;
        this._parameterTypes = parameterTypes;
    }

    public final Type<?> getReturnType() {
        return this._returnType;
    }

    public final TypeList getParameterTypes() {
        return this._parameterTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SignatureType getErasedSignature() {
        if (this._erasedSignature == null) {
            SignatureType signatureType = this;
            synchronized (signatureType) {
                if (this._erasedSignature == null) {
                    Type<?> returnType = this._returnType.getErasedType();
                    TypeList parameterTypes = this._parameterTypes.getErasedTypes();
                    this._erasedSignature = returnType.isEquivalentTo(this._returnType) && parameterTypes.isEquivalentTo(this._parameterTypes) ? this : new SignatureType(returnType, parameterTypes);
                }
            }
        }
        return this._erasedSignature;
    }

    public final boolean isEquivalentTo(SignatureType other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!other._returnType.isEquivalentTo(this._returnType)) {
            return false;
        }
        int parameterCount = this._parameterTypes.size();
        if (other._parameterTypes.size() != parameterCount) {
            return false;
        }
        for (int i = 0; i < parameterCount; ++i) {
            if (TypeUtils.areEquivalent((Type)other._parameterTypes.get(i), (Type)this._parameterTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    public final boolean containsGenericParameters() {
        return this._returnType.containsGenericParameters() || this._parameterTypes.containsGenericParameters();
    }

    public final boolean containsGenericParameter(Type<?> genericParameter) {
        return this._returnType.containsGenericParameter(genericParameter) || this._parameterTypes.containsGenericParameter(genericParameter);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof SignatureType && this.isEquivalentTo((SignatureType)o);
    }

    public final int hashCode() {
        int result = this._returnType.hashCode();
        result = 31 * result + this._parameterTypes.hashCode();
        return result;
    }
}

