/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection.emit;

import com.strobel.core.VerifyArgument;
import com.strobel.reflection.Type;
import com.strobel.reflection.emit.CodeGenerator;
import com.strobel.reflection.emit.Label;
import java.util.Arrays;

final class __ExceptionInfo {
    static final int None = 0;
    static final int Filter = 1;
    static final int Finally = 2;
    static final int PreserveStack = 4;
    static final int State_Try = 0;
    static final int State_Filter = 1;
    static final int State_Catch = 2;
    static final int State_Finally = 3;
    static final int State_Fault = 4;
    static final int State_Done = 5;
    int _startAddress;
    int[] _filterAddress;
    int[] _catchAddress;
    int[] _catchEndAddress;
    int[] _type;
    Type[] _catchClass;
    Label _endLabel;
    Label _finallyEndLabel;
    int _endAddress;
    int _endFinally;
    int _currentCatch;
    int _currentState;

    private __ExceptionInfo() {
        this._startAddress = 0;
        this._filterAddress = null;
        this._catchAddress = null;
        this._catchEndAddress = null;
        this._endAddress = 0;
        this._currentCatch = 0;
        this._type = null;
        this._endFinally = -1;
        this._currentState = 0;
    }

    __ExceptionInfo(int startAddress, Label endLabel) {
        this._startAddress = startAddress;
        this._endAddress = -1;
        this._filterAddress = new int[4];
        this._catchAddress = new int[4];
        this._catchEndAddress = new int[4];
        this._catchClass = new Type[4];
        this._currentCatch = 0;
        this._endLabel = endLabel;
        this._type = new int[4];
        this._endFinally = -1;
        this._currentState = 0;
    }

    private static Type[] enlargeArray(Type[] incoming) {
        return Arrays.copyOf(incoming, incoming.length * 2);
    }

    private void markHelper(int catchOrFilterAddress, int catchEndAddress, Type catchClass, int type) {
        if (this._currentCatch >= this._catchAddress.length) {
            this._filterAddress = CodeGenerator.enlargeArray(this._filterAddress);
            this._catchAddress = CodeGenerator.enlargeArray(this._catchAddress);
            this._catchEndAddress = CodeGenerator.enlargeArray(this._catchEndAddress);
            this._catchClass = __ExceptionInfo.enlargeArray(this._catchClass);
            this._type = CodeGenerator.enlargeArray(this._type);
        }
        if (type == 1) {
            this._type[this._currentCatch] = type;
            this._filterAddress[this._currentCatch] = catchOrFilterAddress;
            this._catchAddress[this._currentCatch] = -1;
            if (this._currentCatch > 0) {
                assert (this._catchEndAddress[this._currentCatch - 1] == -1) : "_catchEndAddress[_currentCatch - 1] == -1";
                this._catchEndAddress[this._currentCatch - 1] = catchOrFilterAddress;
            }
        } else {
            this._catchClass[this._currentCatch] = catchClass;
            if (this._type[this._currentCatch] != 1) {
                this._type[this._currentCatch] = type;
            }
            this._catchAddress[this._currentCatch] = catchOrFilterAddress;
            if (this._currentCatch > 0 && this._type[this._currentCatch] != 1) {
                assert (this._catchEndAddress[this._currentCatch - 1] == -1) : "_catchEndAddress[_currentCatch - 1] == -1";
                this._catchEndAddress[this._currentCatch - 1] = catchEndAddress;
            }
            this._catchEndAddress[this._currentCatch] = -1;
            ++this._currentCatch;
        }
        if (this._endAddress == -1) {
            this._endAddress = catchOrFilterAddress;
        }
    }

    void markFilterAddress(int filterAddress) {
        this._currentState = 1;
        this.markHelper(filterAddress, filterAddress, null, 1);
    }

    void markTryEndAddress(int tryEndAddress) {
        this._endAddress = tryEndAddress;
    }

    void markCatchAddress(int catchAddress, Type catchException) {
        this._currentState = 2;
        this.markHelper(catchAddress, catchAddress, catchException, 0);
    }

    void markFinallyAddress(int finallyAddress, int endCatchAddress) {
        if (this._endFinally != -1) {
            throw new IllegalArgumentException("Too many finally clauses.");
        }
        this._currentState = 3;
        this._endFinally = finallyAddress;
        this.markHelper(finallyAddress, endCatchAddress, null, 2);
    }

    void done(int endAddress) {
        assert (this._currentCatch > 0) : "_currentCatch > 0";
        assert (this._catchAddress[this._currentCatch - 1] > 0) : "_catchAddress[_currentCatch - 1] > 0";
        assert (this._catchEndAddress[this._currentCatch - 1] == -1) : "_catchEndAddress[_currentCatch - 1] == -1";
        this._catchEndAddress[this._currentCatch - 1] = endAddress;
        this._currentState = 5;
    }

    int getStartAddress() {
        return this._startAddress;
    }

    int getEndAddress() {
        return this._endAddress;
    }

    int getFinallyEndAddress() {
        return this._endFinally;
    }

    Label getEndLabel() {
        return this._endLabel;
    }

    int[] getFilterAddresses() {
        return this._filterAddress;
    }

    int[] getCatchAddresses() {
        return this._catchAddress;
    }

    int[] getCatchEndAddresses() {
        return this._catchEndAddress;
    }

    Type[] getCatchClass() {
        return this._catchClass;
    }

    int getNumberOfCatches() {
        return this._currentCatch;
    }

    int[] getExceptionTypes() {
        return this._type;
    }

    void setFinallyEndLabel(Label lbl) {
        this._finallyEndLabel = this._endLabel;
        this._endLabel = lbl;
    }

    Label getFinallyEndLabel() {
        return this._finallyEndLabel;
    }

    boolean isInner(__ExceptionInfo exc) {
        VerifyArgument.notNull((Object)exc, (String)"exc");
        assert (this._currentCatch > 0) : "_currentCatch > 0";
        assert (exc._currentCatch > 0) : "exc._currentCatch > 0";
        int exclast = exc._currentCatch - 1;
        int last = this._currentCatch - 1;
        if (exc._catchEndAddress[exclast] < this._catchEndAddress[last]) {
            return true;
        }
        if (exc._catchEndAddress[exclast] == this._catchEndAddress[last]) {
            assert (exc.getEndAddress() != this.getEndAddress()) : "exc.getEndAddress() != getEndAddress()";
            if (exc.getEndAddress() > this.getEndAddress()) {
                return true;
            }
        }
        return false;
    }

    int getCurrentState() {
        return this._currentState;
    }
}

