/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.traversal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Set;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;
import org.jboss.windup.graph.traversal.TraversalStrategy;

public class OnlyOnceTraversalStrategy
implements TraversalStrategy {
    private Set<String> alreadySeenHashes;

    public OnlyOnceTraversalStrategy() {
        this.reset();
    }

    @Override
    public ProjectModelTraversal.TraversalState getTraversalState(ProjectModelTraversal traversal) {
        return ProjectModelTraversal.TraversalState.ALL;
    }

    @Override
    public void reset() {
        this.alreadySeenHashes = new HashSet<String>();
    }

    @Override
    public Iterable<ProjectModelTraversal> getChildren(final ProjectModelTraversal traversal) {
        ProjectModel canonicalProject = traversal.getCanonicalProject();
        Iterable defaultChildren = Iterables.transform(canonicalProject.getChildProjects(), (Function)new Function<ProjectModel, ProjectModelTraversal>(){

            public ProjectModelTraversal apply(ProjectModel input) {
                return new ProjectModelTraversal(traversal, input, OnlyOnceTraversalStrategy.this);
            }
        });
        return Iterables.filter((Iterable)defaultChildren, (Predicate)new Predicate<ProjectModelTraversal>(){

            public boolean apply(ProjectModelTraversal input) {
                FileModel rootFile = input.getCurrent().getRootFileModel();
                if (!(rootFile instanceof ArchiveModel)) {
                    return true;
                }
                ArchiveModel archive = (ArchiveModel)rootFile;
                if (!OnlyOnceTraversalStrategy.this.alreadySeenHashes.contains(archive.getSHA1Hash())) {
                    OnlyOnceTraversalStrategy.this.alreadySeenHashes.add(archive.getSHA1Hash());
                    return true;
                }
                return false;
            }
        });
    }
}

