/*
 * Decompiled with CFR 0.152.
 */
package com.github.rwitzel.streamflyer.core;

import com.github.rwitzel.streamflyer.internal.thirdparty.ZzzValidate;

public class AfterModification {
    private int newMinimumLengthOfLookBehind;
    private int newNumberOfChars;
    private int numberOfCharactersToSkip;
    private boolean modifyAgainImmediately;

    public AfterModification(int numberOfCharactersToSkip, boolean modifyAgainImmediately, int newMinimumLengthOfLookBehind, int newNumberOfChars) {
        this.init(numberOfCharactersToSkip, modifyAgainImmediately, newMinimumLengthOfLookBehind, newNumberOfChars);
    }

    protected void init(int numberOfCharactersToSkip_, boolean modifyAgainImmediately_, int newMinimumLengthOfLookBehind_, int newNumberOfChars_) {
        ZzzValidate.isZeroOrPositiveNumber(numberOfCharactersToSkip_, "numberOfCharactersToSkip");
        ZzzValidate.isZeroOrPositiveNumber(newMinimumLengthOfLookBehind_, "minimumLengthOfLookBehind");
        ZzzValidate.isZeroOrPositiveNumber(newNumberOfChars_, "newNumberOfChars_");
        if (this.modifyAgainImmediately && numberOfCharactersToSkip_ != 0) {
            throw new IllegalArgumentException("if modify again immediately, the number of characters to skip are ignored .. so why is the number of characters to skip " + numberOfCharactersToSkip_ + " instead of zero?");
        }
        this.numberOfCharactersToSkip = numberOfCharactersToSkip_;
        this.modifyAgainImmediately = modifyAgainImmediately_;
        this.newMinimumLengthOfLookBehind = newMinimumLengthOfLookBehind_;
        this.newNumberOfChars = newNumberOfChars_;
    }

    public int getNewMinimumLengthOfLookBehind() {
        return this.newMinimumLengthOfLookBehind;
    }

    public int getNewNumberOfChars() {
        return this.newNumberOfChars;
    }

    public boolean isModifyAgainImmediately() {
        return this.modifyAgainImmediately;
    }

    public int getNumberOfCharactersToSkip() {
        return this.numberOfCharactersToSkip;
    }

    public String getMessageType() {
        if (this.numberOfCharactersToSkip != 0) {
            return "SKIP";
        }
        if (this.modifyAgainImmediately) {
            return "MODIFY AGAIN IMMEDIATELY";
        }
        return "STOP";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AfterModification [\nnewMinimumLengthOfLookBehind=");
        builder.append(this.newMinimumLengthOfLookBehind);
        builder.append(", \nnewNumberOfModifiableChars=");
        builder.append(this.newNumberOfChars);
        builder.append(", \nnumberOfCharactersToSkip=");
        builder.append(this.numberOfCharactersToSkip);
        builder.append(", \nmodifyAgainImmediately=");
        builder.append(this.modifyAgainImmediately);
        builder.append("]");
        return builder.toString();
    }
}

