/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.xml.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.rules.apps.xml.xml.EnhancedEntityResolver2;
import org.jboss.windup.rules.apps.xml.xml.InvalidXSDURLException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;

class ValidateXmlHandler
extends DefaultHandler2 {
    private static final String XMLSCHEMA_ATTRIBUTE_NAME = "schemaLocation";
    private static final String NO_NAMESPACE_XMLSCHEMA_ATTRIBUTE_NAME = "noNamespaceSchemaLocation";
    private final List<SAXParseException> parseExceptions = new ArrayList<SAXParseException>();
    private final List<String> xsdURLs = new ArrayList<String>();
    private final EnhancedEntityResolver2 entityResolver;
    private boolean firstElementFound = false;
    private Locator locator;
    private boolean onlineMode;

    public ValidateXmlHandler(boolean onlineMode) {
        this.onlineMode = onlineMode;
        this.entityResolver = new EnhancedEntityResolver2(onlineMode);
    }

    public List<String> getXsdURLs() {
        return this.xsdURLs;
    }

    public List<SAXParseException> getParseExceptions() {
        return this.parseExceptions;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        return this.entityResolver.resolveEntity(publicId, systemId);
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        return this.entityResolver.resolveEntity(name, publicId, baseURI, systemId);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    static boolean isNetworkUrl(String url) {
        return url != null && !url.startsWith("file");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this.firstElementFound) {
            this.firstElementFound = true;
            try {
                this.xsdURLs.addAll(this.getXSDLocations(attributes));
                for (String xsdUrl : this.xsdURLs) {
                    try {
                        if (!this.onlineMode && ValidateXmlHandler.isNetworkUrl(xsdUrl)) continue;
                        URLConnection urlConnection = new URL(xsdUrl).openConnection();
                        urlConnection.setConnectTimeout(10000);
                        urlConnection.setReadTimeout(10000);
                        InputStream inputStream = urlConnection.getInputStream();
                    }
                    catch (IOException e) {
                        this.parseExceptions.add(new SAXParseException(e.getMessage(), this.locator, e));
                    }
                }
            }
            catch (InvalidXSDURLException e) {
                this.parseExceptions.add(new SAXParseException(e.getMessage(), this.locator, e));
            }
        }
        super.startElement(uri, localName, qName, attributes);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        super.warning(e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.parseExceptions.add(e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.parseExceptions.add(e);
    }

    private List<String> getXSDLocations(Attributes attributes) throws InvalidXSDURLException {
        String noNamespaceSchema;
        ArrayList<String> xsdUrls = new ArrayList<String>();
        if (attributes == null) {
            return xsdUrls;
        }
        String xsdSchemaAttr = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", XMLSCHEMA_ATTRIBUTE_NAME);
        if (StringUtils.isNotBlank((CharSequence)xsdSchemaAttr)) {
            String[] splittedXslSchemaAttr = xsdSchemaAttr.split("\\s");
            for (int i = 1; i < splittedXslSchemaAttr.length; i += 2) {
                String urlStr = splittedXslSchemaAttr[i];
                xsdUrls.add(urlStr);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(noNamespaceSchema = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", NO_NAMESPACE_XMLSCHEMA_ATTRIBUTE_NAME)))) {
            xsdUrls.add(noNamespaceSchema);
        }
        return xsdUrls;
    }
}

