/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.util;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.forge.furnace.util.Weighted;

public final class ServiceLogger {
    private static final String NEWLINE = OperatingSystemUtils.getLineSeparator();

    public static void logLoadedServices(Logger log, Class<?> type, List<?> services) {
        log.info("Loaded [" + services.size() + "] " + type.getName() + " [" + NEWLINE + ServiceLogger.joinTypeNames(new ArrayList(services)) + "]");
    }

    private static String joinTypeNames(List<?> list) {
        StringBuilder result = new StringBuilder();
        for (Object service : list) {
            result.append("\t").append(service.getClass().getName().replaceAll("_\\$\\$_.*$", ""));
            if (service instanceof Weighted) {
                result.append("<" + ((Weighted)service).priority() + ">");
            }
            result.append(NEWLINE);
        }
        return result.toString();
    }
}

