/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.exec.configuration.options;

import java.util.Collection;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.AbstractConfigurationOption;
import org.jboss.windup.config.InputType;
import org.jboss.windup.config.ValidationResult;
import org.jboss.windup.config.metadata.RuleProviderRegistryCache;

public class TargetOption
extends AbstractConfigurationOption {
    public static final String NAME = "target";
    @Inject
    private RuleProviderRegistryCache cache;

    public Collection<?> getAvailableValues() {
        return this.cache.getAvailableTargetTechnologies();
    }

    public String getName() {
        return NAME;
    }

    public String getLabel() {
        return "Target server or framework";
    }

    public String getDescription() {
        return "The target server/technology/framework to migrate to. This could include multiple items (eg, \"eap\" and \"hibernate\") separated by a space. Use --listTargetTechnologies to get known targets.";
    }

    public InputType getUIType() {
        return InputType.SELECT_MANY;
    }

    public Class<String> getType() {
        return String.class;
    }

    public boolean isRequired() {
        return true;
    }

    public ValidationResult validate(Object values) {
        if (values == null) {
            return new ValidationResult(ValidationResult.Level.ERROR, "target parameter is required!");
        }
        for (Object value : (Iterable)values) {
            if (value instanceof String && ((String)value).contains(":")) {
                value = StringUtils.substringBefore((String)((String)value), (String)":");
            }
            if (this.getAvailableValues().contains(value)) continue;
            return new ValidationResult(ValidationResult.Level.ERROR, "target value (" + value + ") not found, must be one of: " + this.getAvailableValues());
        }
        return ValidationResult.SUCCESS;
    }
}

