/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.xml.model;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.Adjacency;
import com.tinkerpop.frames.Property;
import com.tinkerpop.frames.modules.javahandler.JavaHandler;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerContext;
import com.tinkerpop.frames.modules.typedgraph.TypeValue;
import java.io.InputStream;
import java.util.logging.Logger;
import org.jboss.windup.graph.Indexed;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.SourceFileModel;
import org.jboss.windup.rules.apps.xml.model.DoctypeMetaModel;
import org.jboss.windup.rules.apps.xml.model.NamespaceMetaModel;
import org.jboss.windup.rules.apps.xml.model.XMLDocumentCache;
import org.jboss.windup.util.exception.WindupException;
import org.jboss.windup.util.xml.LocationAwareXmlReader;
import org.w3c.dom.Document;

@TypeValue(value="XmlFileModel")
public interface XmlFileModel
extends FileModel,
SourceFileModel {
    public static final Logger LOG = Logger.getLogger(XmlFileModel.class.getName());
    public static final String NOT_VALID_XML = "XML File is not valid";
    public static final String XSD_URL_NOT_VALID = "XML File references not valid xsd url.";
    public static final String ROOT_TAG_NAME = "rootTagName";
    public static final String NAMESPACE = "namespace";
    public static final String DOCTYPE = "doctype";
    public static final String TYPE = "XmlFileModel";

    @Adjacency(label="doctype", direction=Direction.OUT)
    public void setDoctype(DoctypeMetaModel var1);

    @Adjacency(label="doctype", direction=Direction.OUT)
    public DoctypeMetaModel getDoctype();

    @Adjacency(label="namespace", direction=Direction.OUT)
    public void addNamespace(NamespaceMetaModel var1);

    @Adjacency(label="namespace", direction=Direction.OUT)
    public Iterable<NamespaceMetaModel> getNamespaces();

    @Indexed
    @Property(value="rootTagName")
    public String getRootTagName();

    @Property(value="rootTagName")
    public void setRootTagName(String var1);

    @JavaHandler
    public Document asDocument();

    public static abstract class Impl
    implements XmlFileModel,
    JavaHandlerContext<Vertex> {
        @Override
        public Document asDocument() {
            Document document;
            block16: {
                XMLDocumentCache.Result cacheResult = XMLDocumentCache.get(this);
                if (cacheResult.isParseFailure()) {
                    throw new WindupException("Could not load " + this.asFile() + " due to previous parse failure");
                }
                if (cacheResult.getDocument() == null) {
                    FileModel fileModel = (FileModel)this.frame(this.asVertex(), FileModel.class);
                    try (InputStream is = fileModel.asInputStream();){
                        document = LocationAwareXmlReader.readXML((InputStream)is);
                        XMLDocumentCache.cache(this, document);
                        break block16;
                    }
                    catch (Exception e) {
                        XMLDocumentCache.cacheParseFailure(this);
                        throw new WindupException("Exception reading document due to: " + e.getMessage(), (Throwable)e);
                    }
                }
                document = cacheResult.getDocument();
            }
            return document;
        }
    }
}

