/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.xml.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.rules.apps.xml.model.XMLDocumentCache;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.util.exception.WindupException;
import org.jboss.windup.util.xml.LocationAwareXmlReader;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XmlFileService
extends GraphService<XmlFileModel> {
    private static final Logger LOG = Logger.getLogger(XmlFileService.class.getSimpleName());
    public static final String UNPARSEABLE_XML_CLASSIFICATION = "Unparsable XML File";
    public static final String UNPARSEABLE_XML_DESCRIPTION = "This file could not be parsed";

    public XmlFileService(GraphContext ctx) {
        super(ctx, XmlFileModel.class);
    }

    public Document loadDocumentQuiet(GraphRewrite event, EvaluationContext context, XmlFileModel model) {
        try {
            return this.loadDocument(event, context, model);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Document loadDocument(GraphRewrite event, EvaluationContext context, XmlFileModel model) throws WindupException {
        if (model.asFile().length() == 0L) {
            String msg = "Failed to parse, XML file is empty: " + model.getFilePath();
            LOG.log(Level.WARNING, msg);
            model.setParseError(msg);
            throw new WindupException(msg);
        }
        ClassificationService classificationService = new ClassificationService(this.getGraphContext());
        XMLDocumentCache.Result cacheResult = XMLDocumentCache.get(model);
        if (cacheResult.isParseFailure()) {
            String msg = "Not loading XML file '" + model.getFilePath() + "' due to previous parse failure: " + model.getParseError();
            LOG.log(Level.FINE, msg);
            throw new WindupException(msg);
        }
        Document document = cacheResult.getDocument();
        if (document != null) {
            return document;
        }
        try (InputStream is = model.asInputStream();){
            document = LocationAwareXmlReader.readXML((InputStream)is);
            XMLDocumentCache.cache(model, document);
        }
        catch (IOException | SAXException e) {
            XMLDocumentCache.cacheParseFailure(model);
            document = null;
            String message = "Failed to parse XML file: " + model.getFilePath() + ", due to: " + e.getMessage();
            LOG.log(Level.WARNING, message);
            classificationService.attachClassification(event, context, (FileModel)model, UNPARSEABLE_XML_CLASSIFICATION, UNPARSEABLE_XML_DESCRIPTION);
            model.setParseError(message);
            throw new WindupException(message, (Throwable)e);
        }
        return document;
    }
}

