/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.project.condition;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.condition.EvaluationStrategy;
import org.jboss.windup.config.condition.NoopEvaluationStrategy;
import org.jboss.windup.config.parameters.FrameContext;
import org.jboss.windup.config.parameters.FrameCreationContext;
import org.jboss.windup.config.parameters.ParameterizedGraphCondition;
import org.jboss.windup.graph.model.ProjectDependencyModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.project.condition.Artifact;
import org.jboss.windup.project.condition.ProjectFrom;
import org.jboss.windup.rules.apps.java.model.project.MavenProjectModel;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.util.Maps;

public class Project
extends ParameterizedGraphCondition {
    private Artifact artifact;

    public static Project dependsOnArtifact(Artifact artifact) {
        Project project = new Project();
        project.artifact = artifact;
        return project;
    }

    public static ProjectFrom from(String from) {
        return new ProjectFrom(from);
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public boolean evaluate(GraphRewrite event, EvaluationContext context, EvaluationStrategy evaluationStrategy) {
        GraphService projectService = new GraphService(event.getGraphContext(), ProjectModel.class);
        Iterable findAll = projectService.findAll();
        ArrayList result = new ArrayList();
        for (ProjectModel payload : findAll) {
            Iterable dependencies = payload.getDependencies();
            for (ProjectDependencyModel dependency : dependencies) {
                ProjectModel projectModel = dependency.getProjectModel();
                if (!(projectModel instanceof MavenProjectModel)) continue;
                boolean passed = true;
                MavenProjectModel maven = (MavenProjectModel)projectModel;
                if (this.artifact.getGroupId() != null) {
                    boolean bl = passed = passed && this.artifact.getGroupId().parse(maven.getGroupId()).matches();
                }
                if (this.artifact.getArtifactId() != null) {
                    boolean bl = passed = passed && this.artifact.getArtifactId().parse(maven.getArtifactId()).matches();
                }
                if (passed && this.artifact.getVersion() != null) {
                    boolean bl = passed = passed && this.artifact.getVersion().validate(maven.getVersion());
                }
                if (!passed) continue;
                dependency.getFileLocationReference().forEach(location -> {
                    result.add(location);
                    evaluationStrategy.modelMatched();
                    evaluationStrategy.modelSubmitted((WindupVertexFrame)location);
                });
            }
        }
        if (result.isEmpty()) {
            return false;
        }
        this.setResults(event, this.getOutputVariablesName(), result);
        return true;
    }

    public ConditionBuilder as(String as) {
        super.setOutputVariablesName(as);
        return this;
    }

    public String toString() {
        return "Project.dependsOnArtifact(" + this.artifact.toString() + ")";
    }

    protected boolean evaluateAndPopulateValueStores(GraphRewrite event, EvaluationContext context, final FrameCreationContext frameCreationContext) {
        return this.evaluate(event, context, new EvaluationStrategy(){
            private LinkedHashMap<String, List<WindupVertexFrame>> variables;

            public void modelMatched() {
                this.variables = new LinkedHashMap();
                frameCreationContext.beginNew(this.variables);
            }

            public void modelSubmitted(WindupVertexFrame model) {
                Maps.addListValue(this.variables, (Object)Project.this.getVarname(), (Object)model);
            }

            public void modelSubmissionRejected() {
                frameCreationContext.rollback();
            }
        });
    }

    protected boolean evaluateWithValueStore(GraphRewrite event, EvaluationContext context, FrameContext frameContext) {
        boolean result = this.evaluate(event, context, (EvaluationStrategy)new NoopEvaluationStrategy());
        if (!result) {
            frameContext.reject();
        }
        return result;
    }

    protected String getVarname() {
        return this.getOutputVariablesName();
    }

    public Set<String> getRequiredParameterNames() {
        HashSet<String> result = new HashSet<String>();
        if (this.artifact != null) {
            result.addAll(this.artifact.getRequiredParameterNames());
        }
        return result;
    }

    public void setParameterStore(ParameterStore store) {
        if (this.artifact != null) {
            this.artifact.setParameterStore(store);
        }
    }
}

