/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.schema.Parameter;
import com.thinkaurelius.titan.core.schema.SchemaStatus;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.BackendTransaction;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.EntryMetaData;
import com.thinkaurelius.titan.diskstorage.MetaAnnotatable;
import com.thinkaurelius.titan.diskstorage.ReadBuffer;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.indexing.IndexEntry;
import com.thinkaurelius.titan.diskstorage.indexing.IndexInformation;
import com.thinkaurelius.titan.diskstorage.indexing.IndexQuery;
import com.thinkaurelius.titan.diskstorage.indexing.KeyInformation;
import com.thinkaurelius.titan.diskstorage.indexing.RawQuery;
import com.thinkaurelius.titan.diskstorage.indexing.StandardKeyInformation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.util.BufferUtil;
import com.thinkaurelius.titan.diskstorage.util.HashingUtil;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntry;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.database.idhandling.VariableLong;
import com.thinkaurelius.titan.graphdb.database.management.ManagementSystem;
import com.thinkaurelius.titan.graphdb.database.serialize.AttributeUtil;
import com.thinkaurelius.titan.graphdb.database.serialize.DataOutput;
import com.thinkaurelius.titan.graphdb.database.serialize.Serializer;
import com.thinkaurelius.titan.graphdb.idmanagement.IDManager;
import com.thinkaurelius.titan.graphdb.internal.ElementCategory;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.internal.OrderList;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.query.condition.Condition;
import com.thinkaurelius.titan.graphdb.query.condition.ConditionUtil;
import com.thinkaurelius.titan.graphdb.query.condition.PredicateCondition;
import com.thinkaurelius.titan.graphdb.query.graph.GraphCentricQueryBuilder;
import com.thinkaurelius.titan.graphdb.query.graph.IndexQueryBuilder;
import com.thinkaurelius.titan.graphdb.query.graph.JointIndexQuery;
import com.thinkaurelius.titan.graphdb.query.graph.MultiKeySliceQuery;
import com.thinkaurelius.titan.graphdb.query.vertex.VertexCentricQueryBuilder;
import com.thinkaurelius.titan.graphdb.relations.RelationIdentifier;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.CompositeIndexType;
import com.thinkaurelius.titan.graphdb.types.IndexField;
import com.thinkaurelius.titan.graphdb.types.IndexType;
import com.thinkaurelius.titan.graphdb.types.MixedIndexType;
import com.thinkaurelius.titan.graphdb.types.ParameterIndexField;
import com.thinkaurelius.titan.graphdb.types.ParameterType;
import com.thinkaurelius.titan.util.encoding.LongEncoding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSerializer {
    private static final Logger log = LoggerFactory.getLogger(IndexSerializer.class);
    private static final int DEFAULT_OBJECT_BYTELEN = 30;
    private static final byte FIRST_INDEX_COLUMN_BYTE = 0;
    private final Serializer serializer;
    private final Configuration configuration;
    private final Map<String, ? extends IndexInformation> mixedIndexes;
    private final boolean hashKeys;
    private final HashingUtil.HashLength hashLength = HashingUtil.HashLength.SHORT;

    public IndexSerializer(Configuration config, Serializer serializer, Map<String, ? extends IndexInformation> indexes, boolean hashKeys) {
        this.serializer = serializer;
        this.configuration = config;
        this.mixedIndexes = indexes;
        this.hashKeys = hashKeys;
        if (hashKeys) {
            log.info("Hashing index keys");
        }
    }

    public boolean containsIndex(String indexName) {
        return this.mixedIndexes.containsKey(indexName);
    }

    public String getDefaultFieldName(PropertyKey key, Parameter[] parameters, String indexName) {
        Preconditions.checkArgument((!ParameterType.MAPPED_NAME.hasParameter(parameters) ? 1 : 0) != 0, (String)"A field name mapping has been specified for key: %s", (Object[])new Object[]{key});
        Preconditions.checkArgument((boolean)this.containsIndex(indexName), (String)"Unknown backing index: %s", (Object[])new Object[]{indexName});
        String fieldname = this.configuration.get(GraphDatabaseConfiguration.INDEX_NAME_MAPPING, indexName) != false ? key.getName() : IndexSerializer.keyID2Name(key);
        return this.mixedIndexes.get(indexName).mapKey2Field(fieldname, new StandardKeyInformation(key.getDataType(), parameters));
    }

    public static void register(MixedIndexType index, PropertyKey key, BackendTransaction tx) throws BackendException {
        tx.getIndexTransaction(index.getBackingIndexName()).register(index.getStoreName(), IndexSerializer.key2Field(index, key), IndexSerializer.getKeyInformation(index.getField(key)));
    }

    public boolean supports(MixedIndexType index, ParameterIndexField field, TitanPredicate predicate) {
        IndexInformation indexinfo = this.mixedIndexes.get(index.getBackingIndexName());
        Preconditions.checkArgument((indexinfo != null ? 1 : 0) != 0, (String)"Index is unknown or not configured: %s", (Object[])new Object[]{index.getBackingIndexName()});
        return indexinfo.supports(IndexSerializer.getKeyInformation(field), predicate);
    }

    private static StandardKeyInformation getKeyInformation(ParameterIndexField field) {
        return new StandardKeyInformation(field.getFieldKey().getDataType(), field.getParameters());
    }

    public IndexInfoRetriever getIndexInfoRetriever(StandardTitanTx tx) {
        return new IndexInfoRetriever(tx);
    }

    private static final IndexUpdate.Type getUpateType(InternalRelation relation) {
        assert (relation.isNew() || relation.isRemoved());
        return relation.isNew() ? IndexUpdate.Type.ADD : IndexUpdate.Type.DELETE;
    }

    private static boolean indexAppliesTo(IndexType index, TitanElement element) {
        return !(!index.getElement().isInstance(element) || index instanceof CompositeIndexType && ((CompositeIndexType)index).getStatus() == SchemaStatus.DISABLED || index.hasSchemaTypeConstraint() && !index.getElement().matchesConstraint(index.getSchemaTypeConstraint(), element));
    }

    public Collection<IndexUpdate> getIndexUpdates(InternalRelation relation) {
        assert (relation.isNew() || relation.isRemoved());
        HashSet updates = Sets.newHashSet();
        IndexUpdate.Type updateType = IndexSerializer.getUpateType(relation);
        int ttl = updateType == IndexUpdate.Type.ADD ? StandardTitanGraph.getTTL(relation) : 0;
        for (RelationType type : relation.getPropertyKeysDirect()) {
            if (!(type instanceof PropertyKey)) continue;
            PropertyKey key = (PropertyKey)type;
            for (IndexType index : ((InternalRelationType)((Object)key)).getKeyIndexes()) {
                IndexUpdate<String, IndexEntry> update;
                if (!IndexSerializer.indexAppliesTo(index, relation)) continue;
                if (index instanceof CompositeIndexType) {
                    CompositeIndexType iIndex = (CompositeIndexType)index;
                    RecordEntry[] record = IndexSerializer.indexMatch(relation, iIndex);
                    if (record == null) continue;
                    update = new IndexUpdate(iIndex, updateType, this.getIndexKey(iIndex, record), this.getIndexEntry(iIndex, record, relation), relation);
                } else {
                    assert (relation.getProperty(key) != null);
                    if (((MixedIndexType)index).getField(key).getStatus() == SchemaStatus.DISABLED) continue;
                    update = this.getMixedIndexUpdate(relation, key, relation.getProperty(key), (MixedIndexType)index, updateType);
                }
                if (ttl > 0) {
                    update.setTTL(ttl);
                }
                updates.add(update);
            }
        }
        return updates;
    }

    private static PropertyKey[] getKeysOfRecords(RecordEntry[] record) {
        PropertyKey[] keys = new PropertyKey[record.length];
        for (int i = 0; i < record.length; ++i) {
            keys[i] = record[i].key;
        }
        return keys;
    }

    private static int getIndexTTL(InternalVertex vertex, PropertyKey ... keys) {
        int ttl = StandardTitanGraph.getTTL(vertex);
        for (int i = 0; i < keys.length; ++i) {
            PropertyKey key = keys[i];
            int kttl = ((InternalRelationType)((Object)key)).getTTL();
            if (kttl <= 0 || kttl >= ttl && ttl > 0) continue;
            ttl = kttl;
        }
        return ttl;
    }

    public Collection<IndexUpdate> getIndexUpdates(InternalVertex vertex, Collection<InternalRelation> updatedProperties) {
        if (updatedProperties.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        HashSet updates = Sets.newHashSet();
        for (InternalRelation rel : updatedProperties) {
            assert (rel.isProperty());
            TitanProperty p = (TitanProperty)((Object)rel);
            assert (rel.isNew() || rel.isRemoved());
            assert (rel.getVertex(0).equals(vertex));
            IndexUpdate.Type updateType = IndexSerializer.getUpateType(rel);
            for (IndexType index : ((InternalRelationType)((Object)p.getPropertyKey())).getKeyIndexes()) {
                if (!IndexSerializer.indexAppliesTo(index, vertex)) continue;
                if (index.isCompositeIndex()) {
                    CompositeIndexType cIndex = (CompositeIndexType)index;
                    IndexRecords updateRecords = IndexSerializer.indexMatches(vertex, cIndex, updateType == IndexUpdate.Type.DELETE, p.getPropertyKey(), new RecordEntry(p));
                    for (RecordEntry[] record : updateRecords) {
                        IndexUpdate update = new IndexUpdate(cIndex, updateType, this.getIndexKey(cIndex, record), this.getIndexEntry(cIndex, record, vertex), vertex);
                        int ttl = IndexSerializer.getIndexTTL(vertex, IndexSerializer.getKeysOfRecords(record));
                        if (ttl > 0 && updateType == IndexUpdate.Type.ADD) {
                            update.setTTL(ttl);
                        }
                        updates.add(update);
                    }
                    continue;
                }
                if (((MixedIndexType)index).getField(p.getPropertyKey()).getStatus() == SchemaStatus.DISABLED) continue;
                IndexUpdate<String, IndexEntry> update = this.getMixedIndexUpdate(vertex, p.getPropertyKey(), p.getValue(), (MixedIndexType)index, updateType);
                int ttl = IndexSerializer.getIndexTTL(vertex, p.getPropertyKey());
                if (ttl > 0 && updateType == IndexUpdate.Type.ADD) {
                    update.setTTL(ttl);
                }
                updates.add(update);
            }
        }
        return updates;
    }

    private IndexUpdate<String, IndexEntry> getMixedIndexUpdate(TitanElement element, PropertyKey key, Object value, MixedIndexType index, IndexUpdate.Type updateType) {
        return new IndexUpdate<String, IndexEntry>(index, updateType, IndexSerializer.element2String(element), new IndexEntry(IndexSerializer.key2Field(index.getField(key)), value), element);
    }

    public void reindexElement(TitanElement element, MixedIndexType index, Map<String, Map<String, List<IndexEntry>>> documentsPerStore) {
        if (!IndexSerializer.indexAppliesTo(index, element)) {
            return;
        }
        ArrayList entries = Lists.newArrayList();
        for (ParameterIndexField field : index.getFieldKeys()) {
            Object value;
            PropertyKey key = field.getFieldKey();
            if (field.getStatus() == SchemaStatus.DISABLED || (value = element.getProperty(key.getName())) == null) continue;
            entries.add(new IndexEntry(IndexSerializer.key2Field(field), value));
        }
        HashMap documents = documentsPerStore.get(index.getStoreName());
        if (documents == null) {
            documents = Maps.newHashMap();
            documentsPerStore.put(index.getStoreName(), documents);
        }
        this.getDocuments(documentsPerStore, index).put(IndexSerializer.element2String(element), entries);
    }

    private Map<String, List<IndexEntry>> getDocuments(Map<String, Map<String, List<IndexEntry>>> documentsPerStore, MixedIndexType index) {
        HashMap documents = documentsPerStore.get(index.getStoreName());
        if (documents == null) {
            documents = Maps.newHashMap();
            documentsPerStore.put(index.getStoreName(), documents);
        }
        return documents;
    }

    public void removeElement(Object elementId, MixedIndexType index, Map<String, Map<String, List<IndexEntry>>> documentsPerStore) {
        Preconditions.checkArgument((index.getElement() == ElementCategory.VERTEX && elementId instanceof Long || index.getElement().isRelation() && elementId instanceof RelationIdentifier ? 1 : 0) != 0, (String)"Invalid element id [%s] provided for index: %s", (Object[])new Object[]{elementId, index});
        this.getDocuments(documentsPerStore, index).put(IndexSerializer.element2String(elementId), Lists.newArrayList());
    }

    public Set<IndexUpdate<StaticBuffer, Entry>> reindexElement(TitanElement element, CompositeIndexType index) {
        List records;
        HashSet indexEntries = Sets.newHashSet();
        if (!IndexSerializer.indexAppliesTo(index, element)) {
            return indexEntries;
        }
        if (element instanceof TitanVertex) {
            records = IndexSerializer.indexMatches((TitanVertex)element, index);
        } else {
            assert (element instanceof TitanRelation);
            records = Collections.EMPTY_LIST;
            RecordEntry[] record = IndexSerializer.indexMatch((TitanRelation)element, index);
            if (record != null) {
                records = ImmutableList.of((Object)record);
            }
        }
        for (RecordEntry[] record : records) {
            indexEntries.add(new IndexUpdate(index, IndexUpdate.Type.ADD, this.getIndexKey(index, record), this.getIndexEntry(index, record, element), element));
        }
        return indexEntries;
    }

    public static RecordEntry[] indexMatch(TitanRelation relation, CompositeIndexType index) {
        IndexField[] fields = index.getFieldKeys();
        RecordEntry[] match = new RecordEntry[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            IndexField f = fields[i];
            Object value = relation.getProperty(f.getFieldKey());
            if (value == null) {
                return null;
            }
            match[i] = new RecordEntry(relation.getLongId(), value, f.getFieldKey());
        }
        return match;
    }

    public static IndexRecords indexMatches(TitanVertex vertex, CompositeIndexType index) {
        return IndexSerializer.indexMatches(vertex, index, null, null);
    }

    public static IndexRecords indexMatches(TitanVertex vertex, CompositeIndexType index, PropertyKey replaceKey, Object replaceValue) {
        IndexRecords matches = new IndexRecords();
        IndexField[] fields = index.getFieldKeys();
        if (IndexSerializer.indexAppliesTo(index, vertex)) {
            IndexSerializer.indexMatches(vertex, new RecordEntry[fields.length], matches, fields, 0, false, replaceKey, new RecordEntry(0L, replaceValue, replaceKey));
        }
        return matches;
    }

    private static IndexRecords indexMatches(TitanVertex vertex, CompositeIndexType index, boolean onlyLoaded, PropertyKey replaceKey, RecordEntry replaceValue) {
        IndexRecords matches = new IndexRecords();
        IndexField[] fields = index.getFieldKeys();
        IndexSerializer.indexMatches(vertex, new RecordEntry[fields.length], matches, fields, 0, onlyLoaded, replaceKey, replaceValue);
        return matches;
    }

    private static void indexMatches(TitanVertex vertex, RecordEntry[] current, IndexRecords matches, IndexField[] fields, int pos, boolean onlyLoaded, PropertyKey replaceKey, RecordEntry replaceValue) {
        Object values;
        if (pos >= fields.length) {
            matches.add(current);
            return;
        }
        PropertyKey key = fields[pos].getFieldKey();
        if (key.equals(replaceKey)) {
            values = ImmutableList.of((Object)replaceValue);
        } else {
            Iterable<TitanProperty> props;
            values = new ArrayList();
            if (onlyLoaded || !vertex.isNew() && IDManager.VertexIDType.PartitionedVertex.is(vertex.getLongId())) {
                VertexCentricQueryBuilder qb = ((InternalVertex)vertex).tx().query(vertex);
                ((VertexCentricQueryBuilder)qb.noPartitionRestriction()).type(key);
                if (onlyLoaded) {
                    qb.queryOnlyLoaded();
                }
                props = qb.properties();
            } else {
                props = vertex.getProperties(key);
            }
            for (TitanProperty p : props) {
                assert (!onlyLoaded || p.isLoaded() || p.isRemoved());
                assert (key.getDataType().equals(p.getValue().getClass())) : key + " -> " + p;
                values.add(new RecordEntry(p));
            }
        }
        Iterator i$ = values.iterator();
        while (i$.hasNext()) {
            RecordEntry value;
            current[pos] = value = (RecordEntry)i$.next();
            IndexSerializer.indexMatches(vertex, current, matches, fields, pos + 1, onlyLoaded, replaceKey, replaceValue);
        }
    }

    public List<Object> query(JointIndexQuery.Subquery query, BackendTransaction tx) {
        IndexType index = query.getIndex();
        if (index.isCompositeIndex()) {
            MultiKeySliceQuery sq = query.getCompositeQuery();
            List<EntryList> rs = sq.execute(tx);
            ArrayList<Object> results = new ArrayList<Object>(rs.get(0).size());
            for (EntryList r : rs) {
                Iterator<Entry> iterator = r.reuseIterator();
                block4: while (iterator.hasNext()) {
                    Entry entry = iterator.next();
                    ReadBuffer entryValue = entry.asReadBuffer();
                    entryValue.movePositionTo(entry.getValuePosition());
                    switch (index.getElement()) {
                        case VERTEX: {
                            results.add(VariableLong.readPositive(entryValue));
                            continue block4;
                        }
                    }
                    results.add(IndexSerializer.bytebuffer2RelationId(entryValue));
                }
            }
            return results;
        }
        List<String> r = tx.indexQuery(((MixedIndexType)index).getBackingIndexName(), query.getMixedQuery());
        ArrayList<Object> result = new ArrayList<Object>(r.size());
        for (String id : r) {
            result.add(IndexSerializer.string2ElementId(id));
        }
        return result;
    }

    public MultiKeySliceQuery getQuery(CompositeIndexType index, List<Object[]> values) {
        ArrayList<KeySliceQuery> ksqs = new ArrayList<KeySliceQuery>(values.size());
        for (Object[] value : values) {
            ksqs.add(new KeySliceQuery(this.getIndexKey(index, value), BufferUtil.zeroBuffer(1), BufferUtil.oneBuffer(1)));
        }
        return new MultiKeySliceQuery(ksqs);
    }

    public IndexQuery getQuery(final MixedIndexType index, Condition condition, OrderList orders) {
        Condition<TitanElement> newCondition = ConditionUtil.literalTransformation(condition, new Function<Condition<TitanElement>, Condition<TitanElement>>(){

            @Nullable
            public Condition<TitanElement> apply(@Nullable Condition<TitanElement> condition) {
                Preconditions.checkArgument((boolean)(condition instanceof PredicateCondition));
                PredicateCondition pc = (PredicateCondition)condition;
                PropertyKey key = (PropertyKey)pc.getKey();
                return new PredicateCondition(IndexSerializer.key2Field(index, key), pc.getPredicate(), pc.getValue());
            }
        });
        ImmutableList newOrders = IndexQuery.NO_ORDER;
        if (!orders.isEmpty() && GraphCentricQueryBuilder.indexCoversOrder(index, orders)) {
            ImmutableList.Builder lb = ImmutableList.builder();
            for (int i = 0; i < orders.size(); ++i) {
                lb.add((Object)new IndexQuery.OrderEntry(IndexSerializer.key2Field(index, orders.getKey(i)), orders.getOrder(i), orders.getKey(i).getDataType()));
            }
            newOrders = lb.build();
        }
        return new IndexQuery(index.getStoreName(), newCondition, newOrders);
    }

    public Iterable<RawQuery.Result> executeQuery(IndexQueryBuilder query, ElementCategory resultType, BackendTransaction backendTx, StandardTitanTx transaction) {
        MixedIndexType index = IndexSerializer.getMixedIndex(query.getIndex(), transaction);
        Preconditions.checkArgument((index.getElement() == resultType ? 1 : 0) != 0, (String)"Index is not configured for the desired result type: %s", (Object[])new Object[]{resultType});
        StringBuffer qB = new StringBuffer(query.getQuery());
        String prefix = query.getPrefix();
        Preconditions.checkNotNull((Object)prefix);
        int replacements = 0;
        int pos = 0;
        while (pos < qB.length() && (pos = qB.indexOf(prefix, pos)) >= 0) {
            String replacement;
            boolean quoteTerminated;
            int startPos = pos;
            StringBuilder keyBuilder = new StringBuilder();
            boolean bl = quoteTerminated = qB.charAt(pos += prefix.length()) == '\"';
            if (quoteTerminated) {
                ++pos;
            }
            while (pos < qB.length() && (Character.isLetterOrDigit(qB.charAt(pos)) || quoteTerminated && qB.charAt(pos) != '\"')) {
                keyBuilder.append(qB.charAt(pos));
                ++pos;
            }
            if (quoteTerminated) {
                // empty if block
            }
            int endPos = ++pos;
            String keyname = keyBuilder.toString();
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)keyname), (String)"Found reference to empty key at position [%s]", (Object[])new Object[]{startPos});
            if (transaction.containsRelationType(keyname)) {
                PropertyKey key = transaction.getPropertyKey(keyname);
                Preconditions.checkNotNull((Object)key);
                Preconditions.checkArgument((boolean)index.indexesKey(key), (String)"The used key [%s] is not indexed in the targeted index [%s]", (Object[])new Object[]{key.getName(), query.getIndex()});
                replacement = IndexSerializer.key2Field(index, key);
            } else {
                Preconditions.checkArgument((query.getUnknownKeyName() != null ? 1 : 0) != 0, (String)"Found reference to non-existant property key in query at position [%s]: %s", (Object[])new Object[]{startPos, keyname});
                replacement = query.getUnknownKeyName();
            }
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)replacement));
            qB.replace(startPos, endPos, replacement);
            pos = startPos + replacement.length();
            ++replacements;
        }
        String queryStr = qB.toString();
        if (replacements <= 0) {
            log.warn("Could not convert given {} index query: [{}]", (Object)resultType, (Object)query.getQuery());
        }
        log.info("Converted query string with {} replacements: [{}] => [{}]", new Object[]{replacements, query.getQuery(), queryStr});
        RawQuery rawQuery = new RawQuery(index.getStoreName(), queryStr, query.getParameters());
        if (query.hasLimit()) {
            rawQuery.setLimit(query.getLimit());
        }
        rawQuery.setOffset(query.getOffset());
        return Iterables.transform(backendTx.rawQuery(index.getBackingIndexName(), rawQuery), (Function)new Function<RawQuery.Result<String>, RawQuery.Result>(){

            @Nullable
            public RawQuery.Result apply(@Nullable RawQuery.Result<String> result) {
                return new RawQuery.Result<Object>(IndexSerializer.string2ElementId(result.getResult()), result.getScore());
            }
        });
    }

    private static final MixedIndexType getMixedIndex(String indexName, StandardTitanTx transaction) {
        IndexType index = ManagementSystem.getGraphIndexDirect(indexName, transaction);
        Preconditions.checkArgument((index != null ? 1 : 0) != 0, (String)"Index with name [%s] is unknown or not configured properly", (Object[])new Object[]{indexName});
        Preconditions.checkArgument((boolean)index.isMixedIndex());
        return (MixedIndexType)index;
    }

    private static final String element2String(TitanElement element) {
        return IndexSerializer.element2String(element.getId());
    }

    private static final String element2String(Object elementId) {
        Preconditions.checkArgument((elementId instanceof Long || elementId instanceof RelationIdentifier ? 1 : 0) != 0);
        if (elementId instanceof Long) {
            return IndexSerializer.longID2Name((Long)elementId);
        }
        return ((RelationIdentifier)elementId).toString();
    }

    private static final Object string2ElementId(String str) {
        if (str.contains("-")) {
            return RelationIdentifier.parse(str);
        }
        return IndexSerializer.name2LongID(str);
    }

    private static final String key2Field(MixedIndexType index, PropertyKey key) {
        return IndexSerializer.key2Field(index.getField(key));
    }

    private static final String key2Field(ParameterIndexField field) {
        assert (field != null);
        return ParameterType.MAPPED_NAME.findParameter(field.getParameters(), IndexSerializer.keyID2Name(field.getFieldKey()));
    }

    private static final String keyID2Name(PropertyKey key) {
        return IndexSerializer.longID2Name(key.getLongId());
    }

    private static final String longID2Name(long id) {
        Preconditions.checkArgument((id > 0L ? 1 : 0) != 0);
        return LongEncoding.encode(id);
    }

    private static final long name2LongID(String name) {
        return LongEncoding.decode(name);
    }

    private final StaticBuffer getIndexKey(CompositeIndexType index, RecordEntry[] record) {
        return this.getIndexKey(index, IndexRecords.getValues(record));
    }

    private final StaticBuffer getIndexKey(CompositeIndexType index, Object[] values) {
        DataOutput out = this.serializer.getDataOutput(248);
        VariableLong.writePositive(out, index.getID());
        IndexField[] fields = index.getFieldKeys();
        Preconditions.checkArgument((fields.length > 0 && fields.length == values.length ? 1 : 0) != 0);
        for (int i = 0; i < fields.length; ++i) {
            IndexField f = fields[i];
            Object value = values[i];
            Preconditions.checkNotNull((Object)value);
            if (AttributeUtil.hasGenericDataType(f.getFieldKey())) {
                out.writeClassAndObject(value);
                continue;
            }
            assert (value.getClass().equals(f.getFieldKey().getDataType())) : value.getClass() + " - " + f.getFieldKey().getDataType();
            out.writeObjectNotNull(value);
        }
        StaticBuffer key = out.getStaticBuffer();
        if (this.hashKeys) {
            key = HashingUtil.hashPrefixKey(this.hashLength, key);
        }
        return key;
    }

    private final Entry getIndexEntry(CompositeIndexType index, RecordEntry[] record, TitanElement element) {
        DataOutput out = this.serializer.getDataOutput(9 + 8 * record.length + 32);
        out.putByte((byte)0);
        if (index.getCardinality() != Cardinality.SINGLE) {
            VariableLong.writePositive(out, element.getLongId());
            if (index.getCardinality() != Cardinality.SET) {
                for (RecordEntry re : record) {
                    VariableLong.writePositive(out, re.relationId);
                }
            }
        }
        int valuePosition = out.getPosition();
        if (element instanceof TitanVertex) {
            VariableLong.writePositive(out, element.getLongId());
        } else {
            assert (element instanceof TitanRelation);
            RelationIdentifier rid = (RelationIdentifier)element.getId();
            long[] longs = rid.getLongRepresentation();
            Preconditions.checkArgument((longs.length == 3 || longs.length == 4 ? 1 : 0) != 0);
            for (int i = 0; i < longs.length; ++i) {
                VariableLong.writePositive(out, longs[i]);
            }
        }
        return new StaticArrayEntry(out.getStaticBuffer(), valuePosition);
    }

    private static final RelationIdentifier bytebuffer2RelationId(ReadBuffer b) {
        long[] relationId = new long[4];
        for (int i = 0; i < 3; ++i) {
            relationId[i] = VariableLong.readPositive(b);
        }
        if (b.hasRemaining()) {
            relationId[3] = VariableLong.readPositive(b);
        } else {
            relationId = Arrays.copyOfRange(relationId, 0, 3);
        }
        return RelationIdentifier.get(relationId);
    }

    private static class RecordEntry {
        final long relationId;
        final Object value;
        final PropertyKey key;

        private RecordEntry(long relationId, Object value, PropertyKey key) {
            this.relationId = relationId;
            this.value = value;
            this.key = key;
        }

        private RecordEntry(TitanProperty property) {
            this(property.getLongId(), property.getValue(), property.getPropertyKey());
        }
    }

    public static class IndexRecords
    extends ArrayList<RecordEntry[]> {
        @Override
        public boolean add(RecordEntry[] record) {
            return super.add(Arrays.copyOf(record, record.length));
        }

        public Iterable<Object[]> getRecordValues() {
            return Iterables.transform((Iterable)this, (Function)new Function<RecordEntry[], Object[]>(){

                @Nullable
                public Object[] apply(@Nullable RecordEntry[] record) {
                    return IndexRecords.getValues(record);
                }
            });
        }

        private static Object[] getValues(RecordEntry[] record) {
            Object[] values = new Object[record.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = record[i].value;
            }
            return values;
        }
    }

    public static class IndexUpdate<K, E> {
        private final IndexType index;
        private final Type mutationType;
        private final K key;
        private final E entry;
        private final TitanElement element;

        private IndexUpdate(IndexType index, Type mutationType, K key, E entry, TitanElement element) {
            assert (index != null && mutationType != null && key != null && entry != null && element != null);
            assert (!index.isCompositeIndex() || key instanceof StaticBuffer && entry instanceof Entry);
            assert (!index.isMixedIndex() || key instanceof String && entry instanceof IndexEntry);
            this.index = index;
            this.mutationType = mutationType;
            this.key = key;
            this.entry = entry;
            this.element = element;
        }

        public TitanElement getElement() {
            return this.element;
        }

        public IndexType getIndex() {
            return this.index;
        }

        public Type getType() {
            return this.mutationType;
        }

        public K getKey() {
            return this.key;
        }

        public E getEntry() {
            return this.entry;
        }

        public boolean isAddition() {
            return this.mutationType == Type.ADD;
        }

        public boolean isDeletion() {
            return this.mutationType == Type.DELETE;
        }

        public boolean isCompositeIndex() {
            return this.index.isCompositeIndex();
        }

        public boolean isMixedIndex() {
            return this.index.isMixedIndex();
        }

        public void setTTL(int ttl) {
            Preconditions.checkArgument((ttl > 0 && this.mutationType == Type.ADD ? 1 : 0) != 0);
            ((MetaAnnotatable)this.entry).setMetaData(EntryMetaData.TTL, ttl);
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.index).append((Object)this.mutationType).append(this.key).append(this.entry).toHashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof IndexUpdate)) {
                return false;
            }
            IndexUpdate oth = (IndexUpdate)other;
            return this.index.equals(oth.index) && this.mutationType == oth.mutationType && this.key.equals(oth.key) && this.entry.equals(oth.entry);
        }

        private static enum Type {
            ADD,
            DELETE;

        }
    }

    public static class IndexInfoRetriever
    implements KeyInformation.Retriever {
        private final StandardTitanTx transaction;

        private IndexInfoRetriever(StandardTitanTx tx) {
            Preconditions.checkNotNull((Object)tx);
            this.transaction = tx;
        }

        @Override
        public KeyInformation.IndexRetriever get(final String index) {
            return new KeyInformation.IndexRetriever(){
                Map<String, KeyInformation.StoreRetriever> indexes = new ConcurrentHashMap<String, KeyInformation.StoreRetriever>();

                @Override
                public KeyInformation get(String store, String key) {
                    return this.get(store).get(key);
                }

                @Override
                public KeyInformation.StoreRetriever get(String store) {
                    if (this.indexes.get(store) == null) {
                        Preconditions.checkState((IndexInfoRetriever.this.transaction != null ? 1 : 0) != 0, (Object)"Retriever has not been initialized");
                        MixedIndexType extIndex = IndexSerializer.getMixedIndex(store, IndexInfoRetriever.this.transaction);
                        assert (extIndex.getBackingIndexName().equals(index));
                        ImmutableMap.Builder b = ImmutableMap.builder();
                        for (ParameterIndexField field : extIndex.getFieldKeys()) {
                            b.put((Object)IndexSerializer.key2Field(field), (Object)IndexSerializer.getKeyInformation(field));
                        }
                        final ImmutableMap infoMap = b.build();
                        KeyInformation.StoreRetriever storeRetriever = new KeyInformation.StoreRetriever(){

                            @Override
                            public KeyInformation get(String key) {
                                return (KeyInformation)infoMap.get((Object)key);
                            }
                        };
                        this.indexes.put(store, storeRetriever);
                    }
                    return this.indexes.get(store);
                }
            };
        }
    }
}

