/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query.graph;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.graphdb.internal.ElementCategory;
import com.thinkaurelius.titan.graphdb.internal.OrderList;
import com.thinkaurelius.titan.graphdb.query.BackendQueryHolder;
import com.thinkaurelius.titan.graphdb.query.BaseQuery;
import com.thinkaurelius.titan.graphdb.query.ElementQuery;
import com.thinkaurelius.titan.graphdb.query.QueryUtil;
import com.thinkaurelius.titan.graphdb.query.condition.Condition;
import com.thinkaurelius.titan.graphdb.query.condition.FixedCondition;
import com.thinkaurelius.titan.graphdb.query.graph.JointIndexQuery;
import java.util.Comparator;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class GraphCentricQuery
extends BaseQuery
implements ElementQuery<TitanElement, JointIndexQuery> {
    private final Condition<TitanElement> condition;
    private final BackendQueryHolder<JointIndexQuery> indexQuery;
    private final OrderList orders;
    private final ElementCategory resultType;

    public GraphCentricQuery(ElementCategory resultType, Condition<TitanElement> condition, OrderList orders, BackendQueryHolder<JointIndexQuery> indexQuery, int limit) {
        super(limit);
        Preconditions.checkNotNull(condition);
        Preconditions.checkArgument((orders != null && orders.isImmutable() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)QueryUtil.isQueryNormalForm(condition));
        Preconditions.checkNotNull((Object)((Object)resultType));
        Preconditions.checkNotNull(indexQuery);
        this.condition = condition;
        this.orders = orders;
        this.resultType = resultType;
        this.indexQuery = indexQuery;
    }

    public static final GraphCentricQuery emptyQuery(ElementCategory resultType) {
        FixedCondition<TitanElement> cond = new FixedCondition<TitanElement>(false);
        return new GraphCentricQuery(resultType, cond, OrderList.NO_ORDER, new BackendQueryHolder<JointIndexQuery>(new JointIndexQuery(), true, false, null), 0);
    }

    public Condition<TitanElement> getCondition() {
        return this.condition;
    }

    public ElementCategory getResultType() {
        return this.resultType;
    }

    public OrderList getOrder() {
        return this.orders;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[").append(this.condition.toString()).append("]");
        if (!this.orders.isEmpty()) {
            b.append(this.getLimit());
        }
        if (this.hasLimit()) {
            b.append("(").append(this.getLimit()).append(")");
        }
        b.append(":").append(this.resultType.toString());
        return b.toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.condition).append((Object)this.resultType).append((Object)this.orders).append(this.getLimit()).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        GraphCentricQuery oth = (GraphCentricQuery)other;
        return this.resultType == oth.resultType && this.condition.equals(oth.condition) && this.orders.equals(oth.getOrder()) && this.getLimit() == oth.getLimit();
    }

    @Override
    public boolean isEmpty() {
        return this.getLimit() <= 0;
    }

    @Override
    public int numSubQueries() {
        return 1;
    }

    @Override
    public BackendQueryHolder<JointIndexQuery> getSubQuery(int position) {
        if (position == 0) {
            return this.indexQuery;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean isSorted() {
        return !this.orders.isEmpty();
    }

    @Override
    public Comparator<TitanElement> getSortOrder() {
        if (this.orders.isEmpty()) {
            return new ComparableComparator();
        }
        return this.orders;
    }

    @Override
    public boolean hasDuplicateResults() {
        return false;
    }

    @Override
    public boolean matches(TitanElement element) {
        return this.condition.evaluate(element);
    }
}

