/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query.vertex;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.thinkaurelius.titan.core.BaseVertexQuery;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.attribute.Cmp;
import com.thinkaurelius.titan.core.schema.SchemaInspector;
import com.thinkaurelius.titan.graphdb.internal.OrderList;
import com.thinkaurelius.titan.graphdb.internal.RelationCategory;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.query.condition.PredicateCondition;
import com.thinkaurelius.titan.graphdb.relations.RelationIdentifier;
import com.thinkaurelius.titan.graphdb.types.system.ImplicitKey;
import com.thinkaurelius.titan.graphdb.types.system.SystemRelationType;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Query;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class BaseVertexCentricQueryBuilder<Q extends BaseVertexQuery<Q>>
implements BaseVertexQuery<Q> {
    private static final String[] NO_TYPES = new String[0];
    private static final List<PredicateCondition<String, TitanRelation>> NO_CONSTRAINTS = ImmutableList.of();
    protected Direction dir = Direction.BOTH;
    protected String[] types = NO_TYPES;
    protected List<PredicateCondition<String, TitanRelation>> constraints = NO_CONSTRAINTS;
    protected TitanVertex adjacentVertex = null;
    protected OrderList orders = new OrderList();
    protected int limit = Integer.MAX_VALUE;
    private final SchemaInspector schemaInspector;

    protected BaseVertexCentricQueryBuilder(SchemaInspector schemaInspector) {
        this.schemaInspector = schemaInspector;
    }

    protected abstract Q getThis();

    protected abstract TitanVertex getVertex(long var1);

    @Override
    public Q adjacent(TitanVertex vertex) {
        Preconditions.checkArgument((vertex != null ? 1 : 0) != 0, (Object)"Not a valid vertex provided for adjacency constraint");
        this.adjacentVertex = vertex;
        return this.getThis();
    }

    private Q addConstraint(String type, TitanPredicate rel, Object value) {
        Preconditions.checkArgument((type != null && StringUtils.isNotBlank((String)type) && rel != null ? 1 : 0) != 0);
        if (type.equals(ImplicitKey.ADJACENT_ID.getName())) {
            Preconditions.checkArgument((rel == Cmp.EQUAL ? 1 : 0) != 0, (String)"Only equality constraints are supported for %s", (Object[])new Object[]{type});
            Preconditions.checkArgument((boolean)(value instanceof Number), (String)"Expected valid vertex id: %s", (Object[])new Object[]{value});
            return this.adjacent(this.getVertex(((Number)value).longValue()));
        }
        if (type.equals(ImplicitKey.ID.getName())) {
            Preconditions.checkArgument((boolean)(value instanceof RelationIdentifier), (String)"Expected valid relation id: %s", (Object[])new Object[]{value});
            return this.addConstraint(ImplicitKey.TITANID.getName(), rel, ((RelationIdentifier)value).getRelationId());
        }
        if (this.constraints == NO_CONSTRAINTS) {
            this.constraints = new ArrayList<PredicateCondition<String, TitanRelation>>(5);
        }
        this.constraints.add(new PredicateCondition(type, rel, value));
        return this.getThis();
    }

    @Override
    public Q has(PropertyKey key, Object value) {
        return this.has(key.getName(), value);
    }

    @Override
    public Q has(EdgeLabel label, TitanVertex vertex) {
        return this.has(label.getName(), (Object)vertex);
    }

    @Override
    public Q has(String type, Object value) {
        return this.addConstraint(type, Cmp.EQUAL, value);
    }

    @Override
    public Q hasNot(String key, Object value) {
        return this.has(key, (Predicate)Cmp.NOT_EQUAL, value);
    }

    @Override
    public Q has(String key, Predicate predicate, Object value) {
        return this.addConstraint(key, TitanPredicate.Converter.convert(predicate), value);
    }

    @Override
    public Q has(PropertyKey key, Predicate predicate, Object value) {
        return this.has(key.getName(), predicate, value);
    }

    @Override
    public Q has(String key) {
        return this.has(key, (Predicate)Cmp.NOT_EQUAL, (Object)null);
    }

    @Override
    public Q hasNot(String key) {
        return this.has(key, (Predicate)Cmp.EQUAL, (Object)null);
    }

    @Override
    public <T extends Comparable<?>> Q interval(PropertyKey key, T start, T end) {
        return this.interval(key.getName(), start, end);
    }

    @Override
    public <T extends Comparable<?>> Q interval(String key, T start, T end) {
        this.addConstraint(key, Cmp.GREATER_THAN_EQUAL, start);
        return this.addConstraint(key, Cmp.LESS_THAN, end);
    }

    @Deprecated
    public <T extends Comparable<T>> Q has(String key, T value, Query.Compare compare) {
        return this.addConstraint(key, TitanPredicate.Converter.convert((Predicate)compare), value);
    }

    @Override
    public Q types(RelationType ... types) {
        String[] ts = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            ts[i] = types[i].getName();
        }
        return this.types(ts);
    }

    @Override
    public Q labels(String ... labels) {
        return this.types(labels);
    }

    @Override
    public Q keys(String ... keys) {
        return this.types(keys);
    }

    public Q type(RelationType type) {
        return this.types(type.getName());
    }

    public Q types(String ... types) {
        if (types == null) {
            types = NO_TYPES;
        }
        for (String type : types) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)type), (String)"Invalid type: %s", (Object[])new Object[]{type});
        }
        this.types = types;
        return this.getThis();
    }

    @Override
    public Q direction(Direction d) {
        Preconditions.checkNotNull((Object)d);
        this.dir = d;
        return this.getThis();
    }

    @Override
    public Q limit(int limit) {
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0);
        this.limit = limit;
        return this.getThis();
    }

    @Override
    public Q orderBy(String key, Order order) {
        Preconditions.checkArgument((boolean)this.schemaInspector.containsPropertyKey(key), (String)"Provided key does not exist: %s", (Object[])new Object[]{key});
        return this.orderBy(this.schemaInspector.getPropertyKey(key), order);
    }

    @Override
    public Q orderBy(PropertyKey key, Order order) {
        Preconditions.checkArgument((key != null && order != null ? 1 : 0) != 0, (Object)"Need to specify and key and an order");
        Preconditions.checkArgument((boolean)Comparable.class.isAssignableFrom(key.getDataType()), (String)"Can only order on keys with comparable data type. [%s] has datatype [%s]", (Object[])new Object[]{key.getName(), key.getDataType()});
        Preconditions.checkArgument((key.getCardinality() == Cardinality.SINGLE ? 1 : 0) != 0, (String)"Ordering is undefined on multi-valued key [%s]", (Object[])new Object[]{key.getName()});
        Preconditions.checkArgument((!(key instanceof SystemRelationType) ? 1 : 0) != 0, (String)"Cannot use system types in ordering: %s", (Object[])new Object[]{key});
        Preconditions.checkArgument((!this.orders.containsKey(key) ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)this.orders.isEmpty(), (Object)"Only a single sort order is supported on vertex queries");
        this.orders.add(key, order);
        return this.getThis();
    }

    protected final boolean hasTypes() {
        return this.types.length > 0;
    }

    protected final boolean hasSingleType() {
        return this.types.length == 1 && this.schemaInspector.getRelationType(this.types[0]) != null;
    }

    protected final RelationType getSingleType() {
        Preconditions.checkArgument((boolean)this.hasSingleType());
        return this.schemaInspector.getRelationType(this.types[0]);
    }

    protected final boolean isImplicitKeyQuery(RelationCategory returnType) {
        if (returnType == RelationCategory.EDGE || this.types.length != 1 || !this.constraints.isEmpty()) {
            return false;
        }
        return this.schemaInspector.getRelationType(this.types[0]) instanceof ImplicitKey;
    }
}

