/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.windup.ast.java.data.TypeReferenceLocation;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.projecttraversal.ProjectTraversalCache;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.condition.JavaClass;
import org.jboss.windup.rules.apps.java.model.AbstractJavaSourceModel;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.scan.ast.JavaTypeReferenceModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationListTypeValueModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationLiteralTypeValueModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationTypeReferenceModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationTypeValueModel;
import org.jboss.windup.rules.apps.java.scan.provider.AnalyzeJavaFilesRuleProvider;
import org.jboss.windup.rules.apps.javaee.model.EjbMessageDrivenModel;
import org.jboss.windup.rules.apps.javaee.model.EjbSessionBeanModel;
import org.jboss.windup.rules.apps.javaee.service.JmsDestinationService;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=InitialAnalysisPhase.class, after={AnalyzeJavaFilesRuleProvider.class})
public class DiscoverEjbAnnotationsRuleProvider
extends AbstractRuleProvider {
    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        String ruleIDPrefix = ((Object)((Object)this)).getClass().getSimpleName();
        return ConfigurationBuilder.begin().addRule().when((Condition)JavaClass.references((String)"javax.ejb.{annotationType}").at(new TypeReferenceLocation[]{TypeReferenceLocation.ANNOTATION})).perform((Operation)new AbstractIterationOperation<JavaTypeReferenceModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, JavaTypeReferenceModel payload) {
                DiscoverEjbAnnotationsRuleProvider.this.extractEJBMetadata(event, payload);
            }
        }).where("annotationType").matches("Stateless|Stateful").withId(ruleIDPrefix + "_StatelessAndStatefulRule").addRule().when((Condition)JavaClass.references((String)"javax.ejb.MessageDriven").at(new TypeReferenceLocation[]{TypeReferenceLocation.ANNOTATION})).perform((Operation)new AbstractIterationOperation<JavaTypeReferenceModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, JavaTypeReferenceModel payload) {
                DiscoverEjbAnnotationsRuleProvider.this.extractMessageDrivenMetadata(event, payload);
            }
        }).withId(ruleIDPrefix + "_MessageDrivenRule");
    }

    private String getAnnotationLiteralValue(JavaAnnotationTypeReferenceModel model, String name) {
        JavaAnnotationTypeValueModel valueModel = (JavaAnnotationTypeValueModel)model.getAnnotationValues().get(name);
        if (valueModel instanceof JavaAnnotationLiteralTypeValueModel) {
            JavaAnnotationLiteralTypeValueModel literalTypeValue = (JavaAnnotationLiteralTypeValueModel)valueModel;
            return literalTypeValue.getLiteralValue();
        }
        return null;
    }

    private void extractEJBMetadata(GraphRewrite event, JavaTypeReferenceModel javaTypeReference) {
        javaTypeReference.getFile().setGenerateSourceReport(true);
        JavaAnnotationTypeReferenceModel annotationTypeReference = (JavaAnnotationTypeReferenceModel)javaTypeReference;
        JavaClassModel ejbClass = this.getJavaClass(javaTypeReference);
        String ejbName = this.getAnnotationLiteralValue(annotationTypeReference, "name");
        if (Strings.isNullOrEmpty((String)ejbName)) {
            ejbName = ejbClass.getClassName();
        }
        String sessionType = javaTypeReference.getResolvedSourceSnippit().substring(javaTypeReference.getResolvedSourceSnippit().lastIndexOf(".") + 1);
        GraphService sessionBeanService = new GraphService(event.getGraphContext(), EjbSessionBeanModel.class);
        EjbSessionBeanModel sessionBean = (EjbSessionBeanModel)sessionBeanService.create();
        Set applications = ProjectTraversalCache.getApplicationsForProject((GraphContext)event.getGraphContext(), (ProjectModel)javaTypeReference.getFile().getProjectModel());
        sessionBean.setApplications(applications);
        sessionBean.setBeanName(ejbName);
        sessionBean.setEjbClass(ejbClass);
        sessionBean.setSessionType(sessionType);
    }

    private void extractMessageDrivenMetadata(GraphRewrite event, JavaTypeReferenceModel javaTypeReference) {
        javaTypeReference.getFile().setGenerateSourceReport(true);
        JavaAnnotationTypeReferenceModel annotationTypeReference = (JavaAnnotationTypeReferenceModel)javaTypeReference;
        JavaClassModel ejbClass = this.getJavaClass(javaTypeReference);
        String ejbName = this.getAnnotationLiteralValue(annotationTypeReference, "name");
        if (Strings.isNullOrEmpty((String)ejbName)) {
            ejbName = ejbClass.getClassName();
        }
        JavaAnnotationTypeValueModel activationConfigAnnotation = (JavaAnnotationTypeValueModel)annotationTypeReference.getAnnotationValues().get("activationConfig");
        String destination = this.getAnnotationLiteralValue(annotationTypeReference, "mappedName");
        if (StringUtils.isBlank((CharSequence)destination)) {
            destination = this.getDestinationFromActivationConfig(activationConfigAnnotation);
        }
        GraphService messageDrivenService = new GraphService(event.getGraphContext(), EjbMessageDrivenModel.class);
        EjbMessageDrivenModel messageDrivenBean = (EjbMessageDrivenModel)messageDrivenService.create();
        Set applications = ProjectTraversalCache.getApplicationsForProject((GraphContext)event.getGraphContext(), (ProjectModel)javaTypeReference.getFile().getProjectModel());
        messageDrivenBean.setApplications(applications);
        messageDrivenBean.setBeanName(ejbName);
        messageDrivenBean.setEjbClass(ejbClass);
        if (StringUtils.isNotBlank((CharSequence)destination)) {
            String destinationType = this.getPropertyFromActivationConfig(activationConfigAnnotation, "destinationType");
            JmsDestinationService jmsDestinationService = new JmsDestinationService(event.getGraphContext());
            messageDrivenBean.setDestination(jmsDestinationService.createUnique((Set<ProjectModel>)applications, destination, destinationType));
        }
    }

    private String getDestinationFromActivationConfig(JavaAnnotationTypeValueModel annotationTypeReferenceModel) {
        return this.getPropertyFromActivationConfig(annotationTypeReferenceModel, "destination");
    }

    private String getPropertyFromActivationConfig(JavaAnnotationTypeValueModel annotationTypeReferenceModel, String property) {
        if (property == null) {
            throw new IllegalArgumentException("property cannot be null");
        }
        if (annotationTypeReferenceModel == null) {
            return null;
        }
        if (annotationTypeReferenceModel instanceof JavaAnnotationListTypeValueModel) {
            for (JavaAnnotationTypeValueModel activationConfig : (JavaAnnotationListTypeValueModel)annotationTypeReferenceModel) {
                JavaAnnotationTypeReferenceModel javaAnnotationTypeReferenceModel;
                String propertyValue;
                if (!(activationConfig instanceof JavaAnnotationTypeReferenceModel) || (propertyValue = this.getPropertyFromActivationConfig((JavaAnnotationTypeValueModel)(javaAnnotationTypeReferenceModel = (JavaAnnotationTypeReferenceModel)activationConfig), property)) == null) continue;
                return propertyValue;
            }
            return null;
        }
        if (annotationTypeReferenceModel instanceof JavaAnnotationTypeReferenceModel) {
            JavaAnnotationTypeReferenceModel javaAnnotationTypeReferenceModel = (JavaAnnotationTypeReferenceModel)annotationTypeReferenceModel;
            JavaAnnotationTypeValueModel propertyNameModel = (JavaAnnotationTypeValueModel)javaAnnotationTypeReferenceModel.getAnnotationValues().get("propertyName");
            JavaAnnotationTypeValueModel propertyValueModel = (JavaAnnotationTypeValueModel)javaAnnotationTypeReferenceModel.getAnnotationValues().get("propertyValue");
            if (propertyNameModel instanceof JavaAnnotationLiteralTypeValueModel && propertyValueModel instanceof JavaAnnotationLiteralTypeValueModel) {
                String propertyName = ((JavaAnnotationLiteralTypeValueModel)propertyNameModel).getLiteralValue();
                String propertyValue = ((JavaAnnotationLiteralTypeValueModel)propertyValueModel).getLiteralValue();
                if (property.equals(propertyName)) {
                    return propertyValue;
                }
            }
            return null;
        }
        return null;
    }

    private JavaClassModel getJavaClass(JavaTypeReferenceModel javaTypeReference) {
        JavaClassModel result = null;
        AbstractJavaSourceModel javaSource = javaTypeReference.getFile();
        for (JavaClassModel javaClassModel : javaSource.getJavaClasses()) {
            if (javaClassModel.isPublic() == null || !javaClassModel.isPublic().booleanValue()) continue;
            result = javaClassModel;
            break;
        }
        if (result == null) {
            result = (JavaClassModel)javaSource.getJavaClasses().iterator().next();
        }
        return result;
    }

    public String toString() {
        return "DiscoverEJBAnnotatedClasses";
    }
}

