/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.service;

import com.thinkaurelius.titan.core.attribute.Text;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.frames.structures.FramedVertexIterable;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.javaee.model.association.VendorSpecificationExtensionModel;

public class VendorSpecificationExtensionService
extends GraphService<VendorSpecificationExtensionModel> {
    private static final Logger LOG = Logger.getLogger(VendorSpecificationExtensionService.class.getSimpleName());
    protected final FileService fileService = new FileService(this.getGraphContext());

    public VendorSpecificationExtensionService(GraphContext context) {
        super(context, VendorSpecificationExtensionModel.class);
    }

    public Iterable<VendorSpecificationExtensionModel> getVendorSpecificationExtensions(FileModel model) {
        GremlinPipeline pipeline = new GremlinPipeline((Object)model.asVertex());
        pipeline.out(new String[]{"vendorSpecification"});
        pipeline.has("w:winduptype", (Predicate)Text.CONTAINS, (Object)"VendorSpecificationReferenceModel");
        return new FramedVertexIterable(this.getGraphContext().getFramed(), (Iterable)pipeline, VendorSpecificationExtensionModel.class);
    }

    public VendorSpecificationExtensionModel associateAsVendorExtension(FileModel model, String localFileName) {
        String pathToDescriptor = model.getFilePath();
        pathToDescriptor = StringUtils.removeEnd((String)pathToDescriptor, (String)model.getFileName());
        pathToDescriptor = pathToDescriptor + localFileName;
        FileModel specificationFile = (FileModel)this.fileService.getUniqueByProperty("filePath", (Object)pathToDescriptor);
        VendorSpecificationExtensionModel extension = (VendorSpecificationExtensionModel)this.addTypeToModel((WindupVertexFrame)model);
        if (specificationFile == null) {
            LOG.warning("File not found: " + pathToDescriptor);
        } else {
            extension.setSpecificationFile(specificationFile);
        }
        return extension;
    }
}

