/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ocpsoft.common.pattern.Weighted;
import org.ocpsoft.rewrite.config.CompositeCondition;
import org.ocpsoft.rewrite.config.CompositeOperation;
import org.ocpsoft.rewrite.config.CompositeRule;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.config.ConditionVisit;
import org.ocpsoft.rewrite.config.Conditions;
import org.ocpsoft.rewrite.config.DefaultConditionBuilder;
import org.ocpsoft.rewrite.config.DefaultOperationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.config.OperationBuilder;
import org.ocpsoft.rewrite.config.OperationVisit;
import org.ocpsoft.rewrite.config.Operations;
import org.ocpsoft.rewrite.config.ParameterizedCallback;
import org.ocpsoft.rewrite.config.ParameterizedConditionVisitor;
import org.ocpsoft.rewrite.config.ParameterizedOperationVisitor;
import org.ocpsoft.rewrite.config.RelocatableRule;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.Context;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.param.ConfigurableParameter;
import org.ocpsoft.rewrite.param.DefaultParameter;
import org.ocpsoft.rewrite.param.DefaultParameterStore;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedRule;
import org.ocpsoft.rewrite.util.Visitor;

public final class RuleBuilder
implements ParameterizedRule,
RelocatableRule,
CompositeCondition,
CompositeOperation,
CompositeRule,
Context {
    private final ParameterStore store;
    private Integer priority = null;
    private String id = "";
    private Condition condition;
    private Operation operation;
    protected Map<Object, Object> contextMap = new HashMap<Object, Object>();
    private Rule wrapped;

    private RuleBuilder() {
        this.store = new DefaultParameterStore();
    }

    private RuleBuilder(Rule rule) {
        this.store = new DefaultParameterStore();
        this.withId(rule.getId());
        if (rule instanceof Weighted) {
            this.withPriority(((Weighted)rule).priority());
        }
        this.wrapped = rule;
    }

    public static RuleBuilder define() {
        return new RuleBuilder();
    }

    public static RuleBuilder wrap(Rule rule) {
        return new RuleBuilder(rule);
    }

    public static RuleBuilder define(String id) {
        return RuleBuilder.define().withId(id);
    }

    public RuleBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public RuleBuilder withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public RuleBuilder when(Condition condition) {
        this.condition = this.condition == null ? condition : (condition instanceof ConditionBuilder ? ((ConditionBuilder)this.condition).and(condition) : Conditions.wrap(this.condition).and(condition));
        return this;
    }

    public RuleBuilder perform(Operation operation) {
        this.operation = this.operation == null ? operation : (operation instanceof OperationBuilder ? ((OperationBuilder)this.operation).and(operation) : Operations.wrap(this.operation).and(operation));
        return this;
    }

    @Override
    public boolean evaluate(Rewrite event, EvaluationContext context) {
        context.put(ParameterStore.class, this.store);
        if (this.wrapped != null && this.condition != null) {
            return this.wrapped.evaluate(event, context) && this.condition.evaluate(event, context);
        }
        if (this.wrapped != null) {
            return this.wrapped.evaluate(event, context);
        }
        if (this.condition != null) {
            return this.condition.evaluate(event, context);
        }
        return true;
    }

    @Override
    public void perform(Rewrite event, EvaluationContext context) {
        if (this.wrapped != null) {
            this.wrapped.perform(event, context);
        }
        if (this.operation != null) {
            this.operation.perform(event, context);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public int priority() {
        return this.priority == null ? 0 : this.priority;
    }

    @Override
    public boolean isRelocated() {
        return this.priority != null;
    }

    public DefaultConditionBuilder getConditionBuilder() {
        if (this.condition == null) {
            this.condition = Conditions.create();
        } else if (!(this.condition instanceof DefaultConditionBuilder)) {
            this.condition = Conditions.wrap(this.condition);
        }
        return (DefaultConditionBuilder)this.condition;
    }

    public DefaultOperationBuilder getOperationBuilder() {
        if (this.operation == null) {
            this.operation = Operations.create();
        } else if (!(this.operation instanceof DefaultOperationBuilder)) {
            this.operation = Operations.wrap(this.operation);
        }
        return (DefaultOperationBuilder)this.operation;
    }

    public void accept(Visitor<Condition> visitor) {
        new ConditionVisit(this.condition).accept(visitor);
    }

    @Override
    public List<Operation> getOperations() {
        if (this.wrapped != null && this.operation != null) {
            return Arrays.asList(this.wrapped, this.operation);
        }
        if (this.wrapped != null) {
            return Arrays.asList(this.wrapped);
        }
        if (this.operation != null) {
            return Arrays.asList(this.operation);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Condition> getConditions() {
        if (this.wrapped != null && this.condition != null) {
            return Arrays.asList(this.wrapped, this.condition);
        }
        if (this.wrapped != null) {
            return Arrays.asList(this.wrapped);
        }
        if (this.condition != null) {
            return Arrays.asList(this.condition);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Rule> getRules() {
        return Arrays.asList(this.wrapped);
    }

    @Override
    public ParameterStore getParameterStore() {
        return this.store;
    }

    public ConfigurableParameter<?> where(String name) {
        this.assertParameterExists(name);
        Parameter<?> result = this.getParameterStore().get(name, new DefaultParameter(name));
        if (result instanceof ConfigurableParameter) {
            return (ConfigurableParameter)result;
        }
        throw new RewriteException("Cannot configure read-only parameter [" + name + "].");
    }

    private void assertParameterExists(String name) {
        final LinkedHashSet parameterNames = new LinkedHashSet();
        ParameterizedCallback callback = new ParameterizedCallback(){

            @Override
            public void call(Parameterized parameterized) {
                Set<String> names = parameterized.getRequiredParameterNames();
                parameterNames.addAll(names);
            }
        };
        ParameterizedConditionVisitor conditionVisitor = new ParameterizedConditionVisitor(callback);
        new ConditionVisit(this).accept(conditionVisitor);
        ParameterizedOperationVisitor operationVisitor = new ParameterizedOperationVisitor(callback);
        new OperationVisit(this).accept(operationVisitor);
        if (!parameterNames.contains(name)) {
            throw new IllegalArgumentException("Parameter [" + name + "] does not exist in rule [" + this + "] and cannot be configured.");
        }
    }

    @Override
    public void clear() {
        if (this.wrapped instanceof Context) {
            ((Context)((Object)this.wrapped)).clear();
        }
        this.contextMap.clear();
    }

    @Override
    public Object get(Object key) {
        if (this.wrapped instanceof Context) {
            return ((Context)((Object)this.wrapped)).get(key);
        }
        return this.contextMap.get(key);
    }

    @Override
    public void put(Object key, Object value) {
        if (this.wrapped instanceof Context) {
            ((Context)((Object)this.wrapped)).put(key, value);
        }
        this.contextMap.put(key, value);
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.wrapped instanceof Context) {
            return ((Context)((Object)this.wrapped)).containsKey(key);
        }
        return this.contextMap.containsKey(key);
    }

    @Override
    public Set<String> getRequiredParameterNames() {
        Set<String> names;
        HashSet<String> result = new HashSet<String>();
        if (this.condition instanceof Parameterized && (names = ((Parameterized)((Object)this.condition)).getRequiredParameterNames()) != null) {
            result.addAll(names);
        }
        if (this.operation instanceof Parameterized && (names = ((Parameterized)((Object)this.operation)).getRequiredParameterNames()) != null) {
            result.addAll(names);
        }
        if (this.wrapped instanceof Parameterized && (names = ((Parameterized)((Object)this.wrapped)).getRequiredParameterNames()) != null) {
            result.addAll(names);
        }
        return result;
    }

    @Override
    public void setParameterStore(ParameterStore store) {
        if (this.condition instanceof Parameterized) {
            ((Parameterized)((Object)this.condition)).setParameterStore(store);
        }
        if (this.operation instanceof Parameterized) {
            ((Parameterized)((Object)this.operation)).setParameterStore(store);
        }
        if (this.wrapped instanceof Parameterized) {
            ((Parameterized)((Object)this.wrapped)).setParameterStore(store);
        }
    }

    public String toString() {
        String result = ".addRule(";
        if (this.wrapped != null && !(this.wrapped instanceof RuleBuilder)) {
            result = result + this.wrapped + ")";
        } else {
            result = result + ")";
            if (this.condition instanceof RuleBuilder) {
                String conditionToString = ((RuleBuilder)this.condition).conditionToString();
                if (!conditionToString.isEmpty()) {
                    result = result + ".when(" + conditionToString + ")";
                }
            } else if (this.condition != null) {
                result = result + ".when(" + this.condition + ")";
            }
            if (this.operation instanceof RuleBuilder) {
                String operationToString = ((RuleBuilder)this.operation).operationToString();
                if (!operationToString.isEmpty()) {
                    result = result + ".perform(" + operationToString + ")";
                }
            } else if (this.operation != null) {
                result = result + ".perform(" + this.operation + ")";
            }
        }
        if (this.getId() != null && !this.getId().isEmpty()) {
            result = result + ".withId(\"" + this.getId() + "\")";
        }
        if (this.priority() != 0) {
            result = result + ".withPriority(" + this.priority() + ")";
        }
        return result;
    }

    protected String conditionToString() {
        if (this.condition instanceof RuleBuilder) {
            return ((RuleBuilder)this.condition).conditionToString();
        }
        return this.condition == null ? "" : this.condition.toString();
    }

    protected String operationToString() {
        if (this.operation instanceof RuleBuilder) {
            return ((RuleBuilder)this.operation).conditionToString();
        }
        return this.operation == null ? "" : this.operation.toString();
    }
}

