/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.parameters.ParameterizedIterationOperation;
import org.jboss.windup.graph.model.FileLocationModel;
import org.jboss.windup.graph.model.LinkModel;
import org.jboss.windup.graph.model.resource.SourceFileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.category.IssueCategory;
import org.jboss.windup.reporting.category.IssueCategoryModel;
import org.jboss.windup.reporting.category.IssueCategoryRegistry;
import org.jboss.windup.reporting.config.HintBuilderIn;
import org.jboss.windup.reporting.config.HintBuilderTitle;
import org.jboss.windup.reporting.config.HintEffort;
import org.jboss.windup.reporting.config.HintLink;
import org.jboss.windup.reporting.config.HintQuickfix;
import org.jboss.windup.reporting.config.HintText;
import org.jboss.windup.reporting.config.HintWithIssueCategory;
import org.jboss.windup.reporting.config.Link;
import org.jboss.windup.reporting.model.InlineHintModel;
import org.jboss.windup.reporting.model.QuickfixModel;
import org.jboss.windup.reporting.quickfix.Quickfix;
import org.jboss.windup.reporting.service.TagSetService;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.Logging;
import org.ocpsoft.rewrite.config.OperationBuilder;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;

public class Hint
extends ParameterizedIterationOperation<FileLocationModel>
implements HintText,
HintLink,
HintWithIssueCategory,
HintEffort,
HintQuickfix {
    private static final Logger LOG = Logging.get(Hint.class);
    private RegexParameterizedPatternParser hintTitlePattern;
    private RegexParameterizedPatternParser hintTextPattern;
    private int effort;
    private IssueCategory issueCategory;
    private List<Link> links = new ArrayList<Link>();
    private Set<String> tags = Collections.emptySet();
    private List<Quickfix> quickfixes = new ArrayList<Quickfix>();

    protected Hint(String variable) {
        super(variable);
    }

    protected Hint() {
    }

    public static HintBuilderIn in(String fileVariable) {
        return new HintBuilderIn(fileVariable);
    }

    public static HintBuilderTitle titled(String title) {
        return new HintBuilderTitle(title);
    }

    public static HintText withText(String text) {
        Assert.notNull((Object)text, (String)"Hint text must not be null.");
        Hint hint = new Hint();
        hint.setText(text);
        return hint;
    }

    @Override
    public HintWithIssueCategory withIssueCategory(IssueCategory issueCategory) {
        this.issueCategory = issueCategory;
        return this;
    }

    public IssueCategory getIssueCategory() {
        return this.issueCategory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performParameterized(GraphRewrite event, EvaluationContext context, FileLocationModel locationModel) {
        ExecutionStatistics.get().begin("Hint.performParameterized");
        try {
            String hintText;
            GraphService service = new GraphService(event.getGraphContext(), InlineHintModel.class);
            InlineHintModel hintModel = (InlineHintModel)service.create();
            hintModel.setRuleID(((Rule)context.get(Rule.class)).getId());
            hintModel.setLineNumber(locationModel.getLineNumber());
            hintModel.setColumnNumber(locationModel.getColumnNumber());
            hintModel.setLength(locationModel.getLength());
            hintModel.setFileLocationReference(locationModel);
            hintModel.setFile(locationModel.getFile());
            hintModel.setEffort(this.effort);
            IssueCategoryRegistry issueCategoryRegistry = IssueCategoryRegistry.instance(event.getRewriteContext());
            IssueCategoryModel issueCategoryModel = this.issueCategory == null ? IssueCategoryRegistry.loadFromGraph(event.getGraphContext(), "optional") : IssueCategoryRegistry.loadFromGraph(event.getGraphContext(), this.issueCategory.getCategoryID());
            hintModel.setIssueCategory(issueCategoryModel);
            if (this.hintTitlePattern != null) {
                try {
                    hintModel.setTitle(StringUtils.trim((String)this.hintTitlePattern.getBuilder().build((Rewrite)event, context)));
                }
                catch (Throwable t) {
                    LOG.log(Level.WARNING, "Failed to generate parameterized Hint title due to: " + t.getMessage(), t);
                    hintModel.setTitle(this.hintTitlePattern.toString().trim());
                }
            } else {
                hintModel.setTitle(locationModel.getDescription());
            }
            try {
                hintText = this.hintTextPattern.getBuilder().build((Rewrite)event, context);
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Failed to generate parameterized Hint body due to: " + t.getMessage(), t);
                hintText = this.hintTextPattern.toString();
            }
            hintModel.setHint(StringUtils.trim((String)hintText));
            GraphService linkService = new GraphService(event.getGraphContext(), LinkModel.class);
            for (Link link : this.links) {
                LinkModel linkModel = (LinkModel)linkService.create();
                linkModel.setDescription(StringUtils.trim((String)link.getTitle()));
                linkModel.setLink(StringUtils.trim((String)link.getLink()));
                hintModel.addLink(linkModel);
            }
            GraphService quickfixService = new GraphService(event.getGraphContext(), QuickfixModel.class);
            for (Quickfix quickfix : this.quickfixes) {
                hintModel.addQuickfix(quickfix.createQuickfix(event.getGraphContext()));
            }
            HashSet<String> hashSet = new HashSet<String>(this.getTags());
            TagSetService tagSetService = new TagSetService(event.getGraphContext());
            hintModel.setTagModel(tagSetService.getOrCreate(event, hashSet));
            if (locationModel.getFile() instanceof SourceFileModel) {
                ((SourceFileModel)locationModel.getFile()).setGenerateSourceReport(true);
            }
            LOG.info("Hint added to " + locationModel.getFile().getPrettyPathWithinProject() + " [" + this.toString(hintModel.getTitle(), hintText) + "] with tags: " + StringUtils.join(this.getTags(), (String)" "));
        }
        finally {
            ExecutionStatistics.get().end("Hint.performParameterized");
        }
    }

    @Override
    public HintEffort withEffort(int effort) {
        this.effort = effort;
        return this;
    }

    @Override
    public OperationBuilder withTags(Set<String> tags) {
        this.tags = tags;
        return this;
    }

    @Override
    public HintLink with(Link link) {
        this.links.add(link);
        return this;
    }

    protected void setText(String text) {
        this.hintTextPattern = new RegexParameterizedPatternParser(text);
    }

    protected void setTitle(String title) {
        this.hintTitlePattern = new RegexParameterizedPatternParser(title);
    }

    public RegexParameterizedPatternParser getHintText() {
        return this.hintTextPattern;
    }

    public int getEffort() {
        return this.effort;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public Set<String> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    public Set<String> getRequiredParameterNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.addAll(this.hintTextPattern.getRequiredParameterNames());
        if (this.hintTitlePattern != null) {
            result.addAll(this.hintTitlePattern.getRequiredParameterNames());
        }
        return result;
    }

    public void setParameterStore(ParameterStore store) {
        this.hintTextPattern.setParameterStore(store);
        if (this.hintTitlePattern != null) {
            this.hintTitlePattern.setParameterStore(store);
        }
    }

    public String toString() {
        String title = "";
        if (this.hintTitlePattern != null) {
            title = this.hintTitlePattern.getPattern();
        }
        return this.toString(title, this.hintTextPattern.getPattern());
    }

    private String toString(String title, String text) {
        StringBuilder result = new StringBuilder();
        result.append("Hint");
        if (title != null) {
            result.append(".titled(\"").append(title).append("\")");
        }
        result.append(".withText(\"").append(text).append("\")");
        if (this.effort != 0) {
            result.append(".withEffort(").append(this.effort).append(")");
        }
        if (this.links != null && !this.links.isEmpty()) {
            result.append(".with(").append(this.links).append(")");
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            result.append(".withTags(").append(this.tags).append(")");
        }
        return result.toString();
    }

    public List<Quickfix> getQuickfixes() {
        return this.quickfixes;
    }

    @Override
    public HintQuickfix withQuickfix(Quickfix quickfix) {
        this.quickfixes.add(quickfix);
        return this;
    }
}

