/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker;

import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.furnace.proxy.Proxies;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerTemplateDirective;

public class GetAllFreeMarkerDirectivesMethod
implements WindupFreeMarkerMethod {
    @Inject
    private Imported<WindupFreeMarkerTemplateDirective> directives;

    @Override
    public String getDescription() {
        return "This method takes no parameters, and returns a List of hashes containing a 'name', 'class',  and 'description' field.";
    }

    public Object exec(List arguments) throws TemplateModelException {
        ArrayList results = new ArrayList();
        for (WindupFreeMarkerTemplateDirective directive : this.directives) {
            HashMap<String, String> directiveInfo = new HashMap<String, String>();
            directiveInfo.put("name", directive.getDirectiveName());
            directiveInfo.put("description", directive.getDescription());
            directiveInfo.put("class", Proxies.unwrapProxyClassName(directive.getClass()));
            results.add(directiveInfo);
        }
        return results;
    }

    @Override
    public void setContext(GraphRewrite event) {
    }
}

