/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.model.rule;

import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.Property;
import com.tinkerpop.frames.modules.javahandler.JavaHandler;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerContext;
import com.tinkerpop.frames.modules.typedgraph.TypeValue;
import org.jboss.windup.config.RuleUtils;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.reporting.ruleexecution.RuleExecutionInformationForReading;
import org.ocpsoft.rewrite.config.Rule;

@TypeValue(value="RuleExecution")
public interface RuleExecutionModel
extends WindupVertexFrame {
    public static final String TYPE = "RuleExecution";
    public static final String RULE_ID = "ruleId";
    public static final String RULE_CONTENTS = "ruleContents";
    public static final String COUNT_ADDED_VERTICES = "countAddedVertices";
    public static final String COUNT_ADDED_EDGES = "countAddedEdges";
    public static final String COUNT_REMOVED_VERTICES = "countRemovedVertices";
    public static final String COUNT_REMOVED_EDGES = "countRemovedEdges";
    public static final String IS_EXECUTED = "isExecuted";
    public static final String IS_FAILED = "isFailed";
    public static final String FAILURE_MESSAGE = "failureMessage";

    @Property(value="ruleId")
    public String getRuleId();

    @Property(value="ruleId")
    public RuleExecutionModel setRuleId(String var1);

    @Property(value="ruleContents")
    public String getRuleContents();

    @Property(value="ruleContents")
    public RuleExecutionModel setRuleContents(String var1);

    @Property(value="countAddedVertices")
    public Integer getCountAddedVertices();

    @Property(value="countAddedVertices")
    public RuleExecutionModel setCountAddedVertices(Integer var1);

    @Property(value="countAddedEdges")
    public Integer getCountAddedEdges();

    @Property(value="countAddedEdges")
    public RuleExecutionModel setCountAddedEdges(Integer var1);

    @Property(value="countRemovedVertices")
    public Integer getCountRemovedVertices();

    @Property(value="countRemovedVertices")
    public RuleExecutionModel setCountRemovedVertices(Integer var1);

    @Property(value="countRemovedEdges")
    public Integer getCountRemovedEdges();

    @Property(value="countRemovedEdges")
    public RuleExecutionModel setCountRemovedEdges(Integer var1);

    @Property(value="isExecuted")
    public Boolean getExecuted();

    @Property(value="isExecuted")
    public RuleExecutionModel setExecuted(Boolean var1);

    @Property(value="isFailed")
    public Boolean getFailed();

    @Property(value="isFailed")
    public RuleExecutionModel setFailed(Boolean var1);

    @Property(value="failureMessage")
    public String getFailureMessage();

    @Property(value="failureMessage")
    public RuleExecutionModel setFailureMessage(String var1);

    @JavaHandler
    public void setDataFromRuleInfo(RuleExecutionInformationForReading var1);

    public static abstract class Impl
    implements RuleExecutionModel,
    JavaHandlerContext<Vertex> {
        @Override
        public void setDataFromRuleInfo(RuleExecutionInformationForReading ruleInformation) {
            Rule rule = ruleInformation.getRule();
            this.setRuleId(rule.getId());
            String ruleContents = RuleUtils.ruleToRuleContentsString((Rule)rule, (int)0);
            this.setRuleContents(ruleContents);
            this.setCountAddedVertices(ruleInformation.getVertexIDsAdded());
            this.setCountAddedEdges(ruleInformation.getEdgeIDsAdded());
            this.setCountRemovedVertices(ruleInformation.getVertexIDsRemoved());
            this.setCountRemovedEdges(ruleInformation.getEdgeIDsRemoved());
            this.setExecuted(ruleInformation.isExecuted());
            this.setFailed(ruleInformation.isFailed());
            Throwable failureCase = ruleInformation.getFailureCause();
            if (failureCase != null) {
                String failureMessage = failureCase.getMessage();
                this.setFailureMessage(failureMessage);
            }
        }
    }
}

