/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix;

import cern.colt.PersistentObject;
import cern.colt.list.ObjectArrayList;
import cern.colt.matrix.ObjectMatrix1D;
import cern.colt.matrix.impl.DenseObjectMatrix1D;
import cern.colt.matrix.impl.SparseObjectMatrix1D;

public class ObjectFactory1D
extends PersistentObject {
    public static final ObjectFactory1D dense = new ObjectFactory1D();
    public static final ObjectFactory1D sparse = new ObjectFactory1D();

    protected ObjectFactory1D() {
    }

    public ObjectMatrix1D append(ObjectMatrix1D objectMatrix1D, ObjectMatrix1D objectMatrix1D2) {
        ObjectMatrix1D objectMatrix1D3 = this.make(objectMatrix1D.size() + objectMatrix1D2.size());
        objectMatrix1D3.viewPart(0, objectMatrix1D.size()).assign(objectMatrix1D);
        objectMatrix1D3.viewPart(objectMatrix1D.size(), objectMatrix1D2.size()).assign(objectMatrix1D2);
        return objectMatrix1D3;
    }

    public ObjectMatrix1D make(ObjectMatrix1D[] objectMatrix1DArray) {
        if (objectMatrix1DArray.length == 0) {
            return this.make(0);
        }
        int n = 0;
        for (int i = 0; i < objectMatrix1DArray.length; ++i) {
            n += objectMatrix1DArray[i].size();
        }
        ObjectMatrix1D objectMatrix1D = this.make(n);
        n = 0;
        for (int i = 0; i < objectMatrix1DArray.length; ++i) {
            objectMatrix1D.viewPart(n, objectMatrix1DArray[i].size()).assign(objectMatrix1DArray[i]);
            n += objectMatrix1DArray[i].size();
        }
        return objectMatrix1D;
    }

    public ObjectMatrix1D make(Object[] objectArray) {
        if (this == sparse) {
            return new SparseObjectMatrix1D(objectArray);
        }
        return new DenseObjectMatrix1D(objectArray);
    }

    public ObjectMatrix1D make(int n) {
        if (this == sparse) {
            return new SparseObjectMatrix1D(n);
        }
        return new DenseObjectMatrix1D(n);
    }

    public ObjectMatrix1D make(int n, Object object) {
        return this.make(n).assign(object);
    }

    public ObjectMatrix1D make(ObjectArrayList objectArrayList) {
        int n = objectArrayList.size();
        ObjectMatrix1D objectMatrix1D = this.make(n);
        int n2 = n;
        while (--n2 >= 0) {
            objectMatrix1D.set(n2, objectArrayList.get(n2));
        }
        return objectMatrix1D;
    }

    public ObjectMatrix1D repeat(ObjectMatrix1D objectMatrix1D, int n) {
        int n2 = objectMatrix1D.size();
        ObjectMatrix1D objectMatrix1D2 = this.make(n * n2);
        int n3 = n;
        while (--n3 >= 0) {
            objectMatrix1D2.viewPart(n2 * n3, n2).assign(objectMatrix1D);
        }
        return objectMatrix1D2;
    }

    public ObjectArrayList toList(ObjectMatrix1D objectMatrix1D) {
        int n = objectMatrix1D.size();
        ObjectArrayList objectArrayList = new ObjectArrayList(n);
        objectArrayList.setSize(n);
        int n2 = n;
        while (--n2 >= 0) {
            objectArrayList.set(n2, objectMatrix1D.get(n2));
        }
        return objectArrayList;
    }
}

