/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.addons;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.impl.addons.AddonLifecycleManager;
import org.jboss.forge.furnace.impl.addons.AddonRunnable;
import org.jboss.forge.furnace.impl.addons.AddonStateManager;

public class StartEnabledAddonCallable
implements Callable<Void> {
    private Furnace furnace;
    private AddonLifecycleManager lifecycleManager;
    private AddonStateManager stateManager;
    private ExecutorService executor;
    private AtomicInteger starting;
    private Addon addon;

    public StartEnabledAddonCallable(Furnace furnace, AddonLifecycleManager lifecycleManager, AddonStateManager stateManager, ExecutorService executor, AtomicInteger starting, Addon toStart) {
        this.furnace = furnace;
        this.lifecycleManager = lifecycleManager;
        this.stateManager = stateManager;
        this.executor = executor;
        this.starting = starting;
        this.addon = toStart;
    }

    @Override
    public Void call() {
        if (this.stateManager.canBeStarted(this.addon)) {
            if (this.executor.isShutdown()) {
                throw new IllegalStateException("Cannot start additional addons once Shutdown has been initiated.");
            }
            Future<Object> result = null;
            if (this.stateManager.getRunnableOf(this.addon) == null) {
                this.starting.incrementAndGet();
                AddonRunnable runnable = new AddonRunnable(this.furnace, this.lifecycleManager, this.stateManager, this.addon);
                result = this.executor.submit(runnable, null);
                this.stateManager.setHandles(this.addon, result, runnable);
            }
        }
        return null;
    }

    public String toString() {
        return this.addon.toString();
    }
}

