/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.graph;

import java.util.Set;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.addons.AddonView;
import org.jboss.forge.furnace.impl.addons.AddonLifecycleManager;
import org.jboss.forge.furnace.impl.graph.AddonDependencyEdge;
import org.jboss.forge.furnace.impl.graph.AddonVertex;
import org.jboss.forge.furnace.impl.graph.MasterGraph;
import org.jgrapht.event.TraversalListener;
import org.jgrapht.event.TraversalListenerAdapter;
import org.jgrapht.event.VertexTraversalEvent;
import org.jgrapht.traverse.BreadthFirstIterator;
import org.jgrapht.traverse.DepthFirstIterator;

public class MasterGraphChangeHandler {
    private AddonLifecycleManager lifecycleManager;
    private MasterGraph lastMasterGraph;
    private MasterGraph graph;

    public MasterGraphChangeHandler(AddonLifecycleManager lifefycleManager, MasterGraph currentGraph, MasterGraph graph) {
        this.lifecycleManager = lifefycleManager;
        this.lastMasterGraph = currentGraph;
        this.graph = graph;
    }

    public void hotSwapChanges() {
        this.initGraph();
        this.markDirty();
        this.markRemovedDirty();
        this.stopDirty();
        this.stopRemoved();
        this.loadAddons();
        this.startupIncremental();
        this.clearDirtyStatus();
    }

    private void initGraph() {
        if (this.lastMasterGraph != null) {
            for (AddonVertex last : this.lastMasterGraph.getGraph().vertexSet()) {
                boolean found = false;
                Set vertices = this.graph.getGraph().vertexSet();
                for (AddonVertex vertex : vertices) {
                    if (last.getName().equals(vertex.getName())) {
                        for (AddonView view : vertex.getViews()) {
                            if (!last.getViews().contains(view)) continue;
                            found = true;
                            break;
                        }
                    }
                    if (!found) continue;
                    break;
                }
                if (found || !last.getAddon().getStatus().isLoaded()) continue;
                this.graph.getGraph().addVertex((Object)last);
                last.setDirty(true);
            }
        }
        DepthFirstIterator iterator = new DepthFirstIterator(this.graph.getGraph());
        iterator.addTraversalListener((TraversalListener)new TraversalListenerAdapter<AddonVertex, AddonDependencyEdge>(){

            public void vertexFinished(VertexTraversalEvent<AddonVertex> event) {
                AddonVertex vertex = (AddonVertex)event.getVertex();
                if (vertex.getAddon() == null) {
                    AddonView view = vertex.getViews().iterator().next();
                    AddonId addonId = vertex.getAddonId();
                    Addon addon = null;
                    if (MasterGraphChangeHandler.this.lastMasterGraph != null) {
                        for (AddonVertex last : MasterGraphChangeHandler.this.lastMasterGraph.getGraph().vertexSet()) {
                            if (!last.getAddon().getId().equals((Object)addonId) || !last.getViews().contains(view)) continue;
                            addon = last.getAddon();
                            break;
                        }
                    }
                    vertex.setAddon(addon);
                }
            }
        });
        while (iterator.hasNext()) {
            iterator.next();
        }
        iterator = new DepthFirstIterator(this.graph.getGraph());
        iterator.addTraversalListener((TraversalListener)new TraversalListenerAdapter<AddonVertex, AddonDependencyEdge>(){

            public void vertexFinished(VertexTraversalEvent<AddonVertex> event) {
                AddonVertex vertex = (AddonVertex)event.getVertex();
                if (vertex.getAddon() == null) {
                    AddonView view = vertex.getViews().iterator().next();
                    AddonId addonId = vertex.getAddonId();
                    Addon addon = null;
                    Set<Addon> orphans = MasterGraphChangeHandler.this.lifecycleManager.getOrphanAddons(addonId);
                    if (!orphans.isEmpty()) {
                        addon = orphans.iterator().next();
                    }
                    if (addon == null) {
                        addon = MasterGraphChangeHandler.this.lifecycleManager.getAddon(view, addonId);
                    }
                    vertex.setAddon(addon);
                }
            }
        });
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    private void markDirty() {
        DepthFirstIterator iterator = new DepthFirstIterator(this.graph.getGraph());
        iterator.addTraversalListener((TraversalListener)new TraversalListenerAdapter<AddonVertex, AddonDependencyEdge>(){

            public void vertexFinished(VertexTraversalEvent<AddonVertex> event) {
                AddonVertex vertex = (AddonVertex)event.getVertex();
                Addon addon = vertex.getAddon();
                if (!addon.getStatus().isLoaded() || addon.getStatus().isFailed()) {
                    vertex.setDirty(true);
                }
                for (AddonDependencyEdge edge : MasterGraphChangeHandler.this.graph.getGraph().outgoingEdgesOf((Object)vertex)) {
                    AddonVertex target = (AddonVertex)MasterGraphChangeHandler.this.graph.getGraph().getEdgeTarget((Object)edge);
                    if (!target.isDirty()) continue;
                    vertex.setDirty(true);
                }
                if (MasterGraphChangeHandler.this.lastMasterGraph != null) {
                    boolean equivalent = false;
                    Set<AddonVertex> lastVertices = MasterGraphChangeHandler.this.lastMasterGraph.getVertices(vertex.getName(), vertex.getVersion());
                    for (AddonVertex lastVertex : lastVertices) {
                        if (!MasterGraphChangeHandler.this.graph.isSubtreeEquivalent(vertex, MasterGraphChangeHandler.this.lastMasterGraph.getGraph(), lastVertex)) continue;
                        equivalent = true;
                        break;
                    }
                    if (!equivalent) {
                        vertex.setDirty(true);
                    }
                }
            }
        });
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    private void markRemovedDirty() {
        if (this.lastMasterGraph != null) {
            DepthFirstIterator iterator = new DepthFirstIterator(this.lastMasterGraph.getGraph());
            iterator.addTraversalListener((TraversalListener)new TraversalListenerAdapter<AddonVertex, AddonDependencyEdge>(){

                public void vertexFinished(VertexTraversalEvent<AddonVertex> event) {
                    AddonVertex lastVertex = (AddonVertex)event.getVertex();
                    boolean exists = false;
                    block0: for (AddonVertex vertex : MasterGraphChangeHandler.this.graph.getVertices(lastVertex.getName(), lastVertex.getVersion())) {
                        for (AddonView view : lastVertex.getViews()) {
                            if (!vertex.getViews().contains(view)) continue;
                            exists = true;
                            continue block0;
                        }
                    }
                    if (!exists) {
                        lastVertex.setDirty(true);
                        Set edges = MasterGraphChangeHandler.this.lastMasterGraph.getGraph().incomingEdgesOf((Object)lastVertex);
                        for (AddonDependencyEdge edge : edges) {
                            AddonVertex source = (AddonVertex)MasterGraphChangeHandler.this.lastMasterGraph.getGraph().getEdgeTarget((Object)edge);
                            Set<AddonVertex> vertices = MasterGraphChangeHandler.this.graph.getVertices(source.getName(), source.getVersion());
                            for (AddonVertex vertex : vertices) {
                                vertex.setDirty(true);
                            }
                        }
                    }
                }
            });
            while (iterator.hasNext()) {
                iterator.next();
            }
        }
    }

    private void stopDirty() {
        BreadthFirstIterator iterator = new BreadthFirstIterator(this.graph.getGraph());
        iterator.addTraversalListener((TraversalListener)new TraversalListenerAdapter<AddonVertex, AddonDependencyEdge>(){

            public void vertexTraversed(VertexTraversalEvent<AddonVertex> event) {
                if (((AddonVertex)event.getVertex()).isDirty()) {
                    MasterGraphChangeHandler.this.lifecycleManager.stopAddon(((AddonVertex)event.getVertex()).getAddon());
                }
            }
        });
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    private void stopRemoved() {
        if (this.lastMasterGraph != null) {
            BreadthFirstIterator iterator = new BreadthFirstIterator(this.lastMasterGraph.getGraph());
            iterator.addTraversalListener((TraversalListener)new TraversalListenerAdapter<AddonVertex, AddonDependencyEdge>(){

                public void vertexTraversed(VertexTraversalEvent<AddonVertex> event) {
                    if (((AddonVertex)event.getVertex()).isDirty()) {
                        MasterGraphChangeHandler.this.lifecycleManager.stopAddon(((AddonVertex)event.getVertex()).getAddon());
                    }
                }
            });
            while (iterator.hasNext()) {
                iterator.next();
            }
        }
    }

    private void loadAddons() {
        DepthFirstIterator iterator = new DepthFirstIterator(this.graph.getGraph());
        iterator.addTraversalListener((TraversalListener)new TraversalListenerAdapter<AddonVertex, AddonDependencyEdge>(){

            public void vertexFinished(VertexTraversalEvent<AddonVertex> event) {
                Addon addon = ((AddonVertex)event.getVertex()).getAddon();
                if (!addon.getStatus().isLoaded()) {
                    MasterGraphChangeHandler.this.lifecycleManager.loadAddon(addon);
                }
            }
        });
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    private void startupIncremental() {
        DepthFirstIterator iterator = new DepthFirstIterator(this.graph.getGraph());
        iterator.addTraversalListener((TraversalListener)new TraversalListenerAdapter<AddonVertex, AddonDependencyEdge>(){

            public void vertexFinished(VertexTraversalEvent<AddonVertex> event) {
                Addon addon = ((AddonVertex)event.getVertex()).getAddon();
                if (addon.getStatus().isLoaded()) {
                    MasterGraphChangeHandler.this.lifecycleManager.startAddon(addon);
                }
            }
        });
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    private void clearDirtyStatus() {
        DepthFirstIterator iterator = new DepthFirstIterator(this.graph.getGraph());
        iterator.addTraversalListener((TraversalListener)new TraversalListenerAdapter<AddonVertex, AddonDependencyEdge>(){

            public void vertexFinished(VertexTraversalEvent<AddonVertex> event) {
                ((AddonVertex)event.getVertex()).setDirty(false);
            }
        });
        while (iterator.hasNext()) {
            iterator.next();
        }
    }
}

