/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.graph;

import java.util.Iterator;
import org.jboss.forge.furnace.addons.AddonView;
import org.jboss.forge.furnace.impl.graph.AddonDependencyEdge;
import org.jboss.forge.furnace.impl.graph.AddonVertex;
import org.jgrapht.DirectedGraph;
import org.jgrapht.event.TraversalListener;
import org.jgrapht.event.TraversalListenerAdapter;
import org.jgrapht.event.VertexTraversalEvent;
import org.jgrapht.traverse.BreadthFirstIterator;

public class PrintGraphTraversalListener
extends TraversalListenerAdapter<AddonVertex, AddonDependencyEdge> {
    private static final String MISSING = "MISSING";
    int count = 0;
    private final StringBuilder builder;
    private DirectedGraph<AddonVertex, AddonDependencyEdge> graph;
    private int depth;
    private boolean parentComplete;

    public PrintGraphTraversalListener(DirectedGraph<AddonVertex, AddonDependencyEdge> graph, StringBuilder builder) {
        this(graph, builder, 0, false);
    }

    public PrintGraphTraversalListener(DirectedGraph<AddonVertex, AddonDependencyEdge> graph, StringBuilder builder, int depth, boolean parentComplete) {
        this.graph = graph;
        this.builder = builder;
        this.depth = depth;
        this.parentComplete = parentComplete;
    }

    public void vertexFinished(VertexTraversalEvent<AddonVertex> event) {
        AddonVertex vertex = (AddonVertex)event.getVertex();
        if (this.depth == 0) {
            this.builder.append("\n");
            this.builder.append(this.count++).append(": ").append(vertex.getName()).append(":").append((Object)(vertex.getVersion() == null ? MISSING : vertex.getVersion()));
            this.appendViews(vertex);
            this.builder.append("\n");
        }
        Iterator dependencyIterator = this.graph.outgoingEdgesOf((Object)vertex).iterator();
        while (dependencyIterator.hasNext()) {
            AddonDependencyEdge edge = (AddonDependencyEdge)((Object)dependencyIterator.next());
            AddonVertex dependency = (AddonVertex)this.graph.getEdgeTarget((Object)edge);
            this.indent();
            if (dependencyIterator.hasNext()) {
                this.builder.append("  +- ");
            } else {
                this.builder.append("  \\- ");
            }
            this.builder.append(dependency.getName()).append(":").append(edge.getVersionRange()).append(" -> ");
            this.builder.append((Object)(dependency.getVersion() == null ? MISSING : dependency.getVersion()));
            if (edge.isExported()) {
                this.builder.append(" (E)");
            }
            this.appendViews(dependency);
            this.builder.append("\n");
            BreadthFirstIterator iterator = new BreadthFirstIterator(this.graph, (Object)dependency);
            iterator.addTraversalListener((TraversalListener)new PrintGraphTraversalListener(this.graph, this.builder, this.depth + 1, dependencyIterator.hasNext()));
            while (iterator.hasNext()) {
                iterator.next();
            }
        }
    }

    private void appendViews(AddonVertex dependency) {
        this.builder.append(" - Views[");
        Iterator<AddonView> viewIterator = dependency.getViews().iterator();
        while (viewIterator.hasNext()) {
            AddonView view = viewIterator.next();
            this.builder.append(view.getName());
            if (!viewIterator.hasNext()) continue;
            this.builder.append(", ");
        }
        this.builder.append("] ");
    }

    private void indent() {
        for (int i = 0; i < this.depth; ++i) {
            this.builder.append("  ");
            if (i < this.depth && this.parentComplete) {
                this.builder.append("|");
                continue;
            }
            this.builder.append(" ");
        }
    }

    public String toString() {
        return this.builder.toString();
    }
}

