/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.engine.visitor.inspector;

import com.tinkerpop.blueprints.Vertex;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.jboss.windup.engine.visitor.AbstractGraphVisitor;
import org.jboss.windup.engine.visitor.GraphVisitor;
import org.jboss.windup.engine.visitor.VisitorPhase;
import org.jboss.windup.engine.visitor.inspector.BasicVisitor;
import org.jboss.windup.engine.visitor.inspector.ZipArchiveGraphVisitor;
import org.jboss.windup.graph.dao.ArchiveDao;
import org.jboss.windup.graph.dao.ArchiveEntryDao;
import org.jboss.windup.graph.dao.FileResourceDao;
import org.jboss.windup.graph.model.resource.ArchiveEntryResource;
import org.jboss.windup.graph.model.resource.ArchiveResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveEntryIndexVisitor
extends AbstractGraphVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(ArchiveEntryIndexVisitor.class);
    @Inject
    FileResourceDao fileDao;
    @Inject
    private ArchiveDao archiveDao;
    @Inject
    private ArchiveEntryDao archiveEntryDao;

    @Override
    public List<Class<? extends GraphVisitor>> getDependencies() {
        return super.generateDependencies(BasicVisitor.class, ZipArchiveGraphVisitor.class);
    }

    @Override
    public VisitorPhase getPhase() {
        return VisitorPhase.DISCOVERY;
    }

    @Override
    public void run() {
        int total = (int)this.archiveDao.count(this.archiveDao.getAll());
        int i = 1;
        for (ArchiveResource archive : this.archiveDao.getAll()) {
            this.visitArchive(archive);
            LOG.info("Processed: " + i + " of " + total + " Archives.");
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitArchive(ArchiveResource result) {
        block6: {
            Vertex v = result.asVertex();
            ArchiveResource file = (ArchiveResource)this.archiveDao.getById(v.getId());
            ZipFile zipFileReference = null;
            try {
                File zipFile = this.archiveDao.asFile(result);
                zipFileReference = new ZipFile(zipFile);
                Enumeration<? extends ZipEntry> entries = zipFileReference.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory()) continue;
                    ArchiveEntryResource resource = (ArchiveEntryResource)this.archiveEntryDao.create();
                    resource.setArchiveEntry(entry.getName());
                    resource.setArchive(file);
                }
                IOUtils.closeQuietly((Closeable)zipFileReference);
            }
            catch (IOException e) {
                LOG.error("Exception while reading JAR.", (Throwable)e);
                break block6;
            }
            finally {
                IOUtils.closeQuietly(zipFileReference);
                this.archiveDao.commit();
            }
            this.archiveDao.commit();
        }
    }
}

