/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.engine.visitor.inspector;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.jboss.windup.engine.visitor.AbstractGraphVisitor;
import org.jboss.windup.engine.visitor.VisitorPhase;
import org.jboss.windup.graph.dao.ArchiveDao;
import org.jboss.windup.graph.dao.FileResourceDao;
import org.jboss.windup.graph.model.resource.ArchiveResource;

public class ArchiveHashVisitor
extends AbstractGraphVisitor {
    private static final Logger LOG = Logger.getLogger(ArchiveHashVisitor.class.getName());
    @Inject
    private FileResourceDao fileDao;
    @Inject
    private ArchiveDao archiveDao;

    @Override
    public VisitorPhase getPhase() {
        return VisitorPhase.INITIAL_ANALYSIS;
    }

    @Override
    public void run() {
        for (ArchiveResource archive : this.archiveDao.getAll()) {
            this.visitArchive(archive);
        }
        this.fileDao.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitArchive(ArchiveResource file) {
        InputStream is = null;
        try {
            is = this.archiveDao.getPayload(file);
            String md5 = DigestUtils.md5Hex((InputStream)is);
            is = this.archiveDao.getPayload(file);
            String sha1 = DigestUtils.sha1Hex((InputStream)is);
            file.setSHA1Hash(sha1);
            file.setMD5Hash(md5);
        }
        catch (IOException e) {
            try {
                LOG.log(Level.SEVERE, "Exception generating hash.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        IOUtils.closeQuietly((InputStream)is);
    }
}

