/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.engine.visitor.inspector;

import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.VertexFrame;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.engine.visitor.AbstractGraphVisitor;
import org.jboss.windup.engine.visitor.GraphVisitor;
import org.jboss.windup.engine.visitor.VisitorPhase;
import org.jboss.windup.engine.visitor.inspector.ZipArchiveGraphVisitor;
import org.jboss.windup.graph.dao.ArchiveDao;
import org.jboss.windup.graph.dao.EarArchiveDao;
import org.jboss.windup.graph.dao.JarArchiveDao;
import org.jboss.windup.graph.dao.WarArchiveDao;
import org.jboss.windup.graph.model.resource.ArchiveResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveTypingVisitor
extends AbstractGraphVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(ArchiveTypingVisitor.class);
    @Inject
    private WarArchiveDao warDao;
    @Inject
    private JarArchiveDao jarDao;
    @Inject
    private EarArchiveDao earDao;
    @Inject
    private ArchiveDao archiveDao;

    @Override
    public List<Class<? extends GraphVisitor>> getDependencies() {
        return super.generateDependencies(ZipArchiveGraphVisitor.class);
    }

    @Override
    public VisitorPhase getPhase() {
        return VisitorPhase.DISCOVERY;
    }

    @Override
    public void run() {
        for (ArchiveResource archive : this.archiveDao.getAll()) {
            this.visitArchive(archive);
        }
    }

    @Override
    public void visitArchive(ArchiveResource file) {
        String filePath = file.getFileResource().getFilePath();
        if (StringUtils.endsWith((String)filePath, (String)".jar")) {
            this.jarDao.castToType((VertexFrame)file);
        } else if (StringUtils.endsWith((String)filePath, (String)".war")) {
            this.warDao.castToType((VertexFrame)file);
        } else if (StringUtils.endsWith((String)filePath, (String)".ear")) {
            this.earDao.castToType((VertexFrame)file);
        } else {
            Vertex v = file.asVertex();
            LOG.info("Not found for Vertex: " + v);
            for (String key : v.getPropertyKeys()) {
                LOG.info(" - " + key + " -> " + v.getProperty(key));
            }
            LOG.warn("Extension not routed for: " + filePath);
        }
    }
}

