/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.engine.visitor.inspector;

import com.thinkaurelius.titan.core.TitanGraph;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.modules.typedgraph.TypeValue;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.engine.visitor.AbstractGraphVisitor;
import org.jboss.windup.engine.visitor.VisitorPhase;
import org.jboss.windup.graph.WindupContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugVisitor
extends AbstractGraphVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(DebugVisitor.class);
    private final WindupContext context;
    private final String typeValue;

    public DebugVisitor(WindupContext context, Class<?> type) {
        TypeValue value = type.getAnnotation(TypeValue.class);
        this.typeValue = value.value();
        this.context = context;
    }

    public DebugVisitor(WindupContext context) {
        this.typeValue = null;
        this.context = context;
    }

    @Override
    public VisitorPhase getPhase() {
        return VisitorPhase.REPORTING;
    }

    @Override
    public void run() {
        Iterable vertices;
        TitanGraph graph = this.context.getGraphContext().getGraph();
        if (StringUtils.isNotBlank((String)this.typeValue)) {
            LOG.info("Loading: " + this.typeValue);
            vertices = graph.getVertices("type", (Object)this.typeValue);
        } else {
            vertices = graph.getVertices();
        }
        for (Vertex v : vertices) {
            LOG.info("Vertex[" + v + "]");
            for (String key : v.getPropertyKeys()) {
                LOG.info("  - key[" + key + "] => " + v.getProperty(key));
            }
            for (Edge edge : v.query().direction(Direction.IN).edges()) {
                LOG.info("  - edge[" + edge.getLabel() + ", IN]");
            }
            for (Edge edge : v.query().direction(Direction.OUT).edges()) {
                LOG.info("  - edge[" + edge.getLabel() + ", OUT]");
            }
        }
    }
}

