/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.engine.visitor.inspector;

import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.jboss.windup.engine.visitor.AbstractGraphVisitor;
import org.jboss.windup.engine.visitor.GraphVisitor;
import org.jboss.windup.engine.visitor.VisitorPhase;
import org.jboss.windup.engine.visitor.inspector.BasicVisitor;
import org.jboss.windup.graph.dao.FileResourceDao;
import org.jboss.windup.graph.model.resource.FileResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryVisitor
extends AbstractGraphVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryVisitor.class);
    @Inject
    private FileResourceDao fileDao;

    @Override
    public List<Class<? extends GraphVisitor>> getDependencies() {
        return super.generateDependencies(BasicVisitor.class);
    }

    @Override
    public VisitorPhase getPhase() {
        return VisitorPhase.DISCOVERY;
    }

    @Override
    public void run() {
        for (FileResource file : this.fileDao.getAll()) {
            this.visitFile(file);
        }
    }

    @Override
    public void visitFile(FileResource file) {
        LOG.info(file.getFilePath());
        String filePath = file.getFilePath();
        File fileReference = new File(filePath);
        if (fileReference.isDirectory()) {
            LOG.info("Directory: " + filePath);
            Collection found = FileUtils.listFiles((File)fileReference, (IOFileFilter)FileFileFilter.FILE, (IOFileFilter)TrueFileFilter.INSTANCE);
            for (File reference : found) {
                FileResource graphReference = this.fileDao.getByFilePath(reference.getAbsolutePath());
                this.visitFile(graphReference);
            }
        }
    }
}

