/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.engine.visitor.inspector;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.engine.util.xml.DoctypeUtils;
import org.jboss.windup.engine.util.xml.NamespaceUtils;
import org.jboss.windup.engine.visitor.AbstractGraphVisitor;
import org.jboss.windup.engine.visitor.GraphVisitor;
import org.jboss.windup.engine.visitor.VisitorPhase;
import org.jboss.windup.engine.visitor.inspector.XmlResourceVisitor;
import org.jboss.windup.graph.dao.EJBConfigurationDao;
import org.jboss.windup.graph.dao.EJBEntityDao;
import org.jboss.windup.graph.dao.EJBSessionBeanDao;
import org.jboss.windup.graph.dao.EnvironmentReferenceDao;
import org.jboss.windup.graph.dao.JavaClassDao;
import org.jboss.windup.graph.dao.MessageDrivenDao;
import org.jboss.windup.graph.dao.XmlResourceDao;
import org.jboss.windup.graph.model.meta.EnvironmentReference;
import org.jboss.windup.graph.model.meta.Meta;
import org.jboss.windup.graph.model.meta.javaclass.EjbEntityFacet;
import org.jboss.windup.graph.model.meta.javaclass.EjbSessionBeanFacet;
import org.jboss.windup.graph.model.meta.javaclass.MessageDrivenBeanFacet;
import org.jboss.windup.graph.model.meta.xml.DoctypeMeta;
import org.jboss.windup.graph.model.meta.xml.EjbConfigurationFacet;
import org.jboss.windup.graph.model.meta.xml.NamespaceMeta;
import org.jboss.windup.graph.model.resource.JavaClass;
import org.jboss.windup.graph.model.resource.XmlResource;
import org.joox.JOOX;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EjbConfigurationVisitor
extends AbstractGraphVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(EjbConfigurationVisitor.class);
    private static final String dtdRegex = "(?i).*enterprise.javabeans.*";
    @Inject
    private EnvironmentReferenceDao envRefDao;
    @Inject
    private EJBConfigurationDao ejbConfigurationDao;
    @Inject
    private XmlResourceDao xmlDao;
    @Inject
    private JavaClassDao javaClassDao;
    @Inject
    private EJBEntityDao ejbEntityDao;
    @Inject
    private MessageDrivenDao mdbDao;
    @Inject
    private EJBSessionBeanDao sessionBeanDao;

    @Override
    public List<Class<? extends GraphVisitor>> getDependencies() {
        return this.generateDependencies(XmlResourceVisitor.class);
    }

    @Override
    public VisitorPhase getPhase() {
        return VisitorPhase.INITIAL_ANALYSIS;
    }

    @Override
    public void run() {
        for (XmlResource xml : this.xmlDao.findByRootTag("ejb-jar")) {
            String version;
            Document doc = this.xmlDao.asDocument(xml);
            if (xml.getDoctype() != null) {
                if (!this.processDoctypeMatches(xml.getDoctype())) continue;
                String version2 = this.processDoctypeVersion(xml.getDoctype());
                this.visitXmlResource(xml, doc, version2);
                continue;
            }
            String namespace = JOOX.$((Document)doc).find("ejb-jar").namespaceURI();
            if (StringUtils.isBlank((String)namespace)) {
                namespace = doc.getFirstChild().getNamespaceURI();
            }
            if (StringUtils.isBlank((String)(version = JOOX.$((Document)doc).find("ejb-jar").first().attr("version")))) {
                for (NamespaceMeta ns : xml.getNamespaces()) {
                    LOG.debug("Namespace URI: " + ns.getURI());
                    if (!StringUtils.equals((String)ns.getURI(), (String)namespace)) continue;
                    LOG.debug("Schema Location: " + ns.getSchemaLocation());
                    version = NamespaceUtils.extractVersion((String)ns.getSchemaLocation());
                    LOG.debug("Version: " + version);
                }
            }
            this.visitXmlResource(xml, doc, version);
        }
    }

    public void visitXmlResource(XmlResource xml, Document doc, String versionInformation) {
        EjbConfigurationFacet facet = (EjbConfigurationFacet)this.ejbConfigurationDao.create();
        facet.setXmlFacet(xml);
        if (StringUtils.isNotBlank((String)versionInformation)) {
            facet.setSpecificationVersion(versionInformation);
        }
        for (Element element : JOOX.$((Document)doc).find("session").get()) {
            this.processSessionBeanElement(facet, element);
        }
        for (Element element : JOOX.$((Document)doc).find("message-driven").get()) {
            this.processMessageDrivenElement(facet, element);
        }
        for (Element element : JOOX.$((Document)doc).find("entity").get()) {
            this.processMessageDrivenElement(facet, element);
        }
    }

    public boolean processDoctypeMatches(DoctypeMeta entry) {
        if (StringUtils.isNotBlank((String)entry.getPublicId()) && Pattern.matches(dtdRegex, entry.getPublicId())) {
            return true;
        }
        return StringUtils.isNotBlank((String)entry.getSystemId()) && Pattern.matches(dtdRegex, entry.getSystemId());
    }

    public String processDoctypeVersion(DoctypeMeta entry) {
        String publicId = entry.getPublicId();
        String systemId = entry.getSystemId();
        String versionInformation = DoctypeUtils.extractVersion((String)publicId, (String)systemId);
        return versionInformation;
    }

    protected void processSessionBeanElement(EjbConfigurationFacet ejbConfig, Element element) {
        String ejbClz;
        String remoteClz;
        String homeClz;
        String localHomeClz;
        JavaClass home = null;
        JavaClass localHome = null;
        JavaClass remote = null;
        JavaClass local = null;
        JavaClass ejb = null;
        String ejbId = this.extractAttributeAndTrim(element, "id");
        String displayName = this.extractChildTagAndTrim(element, "display-name");
        String ejbName = this.extractChildTagAndTrim(element, "ejb-name");
        String localClz = this.extractChildTagAndTrim(element, "local");
        if (localClz != null) {
            local = this.javaClassDao.getJavaClass(localClz);
        }
        if ((localHomeClz = this.extractChildTagAndTrim(element, "local-home")) != null) {
            localHome = this.javaClassDao.getJavaClass(localHomeClz);
        }
        if ((homeClz = this.extractChildTagAndTrim(element, "home")) != null) {
            home = this.javaClassDao.getJavaClass(homeClz);
        }
        if ((remoteClz = this.extractChildTagAndTrim(element, "remote")) != null) {
            remote = this.javaClassDao.getJavaClass(remoteClz);
        }
        if ((ejbClz = this.extractChildTagAndTrim(element, "ejb-class")) != null) {
            ejb = this.javaClassDao.getJavaClass(ejbClz);
        }
        String sessionType = this.extractChildTagAndTrim(element, "session-type");
        String transactionType = this.extractChildTagAndTrim(element, "transaction-type");
        EjbSessionBeanFacet sessionBean = (EjbSessionBeanFacet)this.sessionBeanDao.create();
        sessionBean.setEjbId(ejbId);
        sessionBean.setDisplayName(displayName);
        sessionBean.setSessionBeanName(ejbName);
        sessionBean.setEjbLocal(local);
        sessionBean.setEjbLocalHome(localHome);
        sessionBean.setEjbHome(home);
        sessionBean.setEjbRemote(remote);
        sessionBean.setJavaClassFacet(ejb);
        sessionBean.setSessionType(sessionType);
        sessionBean.setTransactionType(transactionType);
        List<EnvironmentReference> refs = this.processEnvironmentReference(element);
        for (EnvironmentReference ref : refs) {
            sessionBean.addMeta((Meta)ref);
        }
        ejbConfig.addEjbSessionBean(sessionBean);
        this.mdbDao.commit();
    }

    protected void processMessageDrivenElement(EjbConfigurationFacet ejbConfig, Element element) {
        JavaClass ejb = null;
        String ejbId = this.extractAttributeAndTrim(element, "id");
        String displayName = this.extractChildTagAndTrim(element, "display-name");
        String ejbName = this.extractChildTagAndTrim(element, "ejb-name");
        String ejbClz = this.extractChildTagAndTrim(element, "ejb-class");
        if (ejbClz != null) {
            ejb = this.javaClassDao.getJavaClass(ejbClz);
        }
        String sessionType = this.extractChildTagAndTrim(element, "session-type");
        String transactionType = this.extractChildTagAndTrim(element, "transaction-type");
        MessageDrivenBeanFacet mdb = (MessageDrivenBeanFacet)this.mdbDao.create();
        mdb.setJavaClassFacet(ejb);
        mdb.setMessageDrivenBeanName(ejbName);
        mdb.setDisplayName(displayName);
        mdb.setEjbId(ejbId);
        mdb.setSessionType(sessionType);
        mdb.setTransactionType(transactionType);
        List<EnvironmentReference> refs = this.processEnvironmentReference(element);
        for (EnvironmentReference ref : refs) {
            mdb.addMeta((Meta)ref);
        }
        ejbConfig.addMessageDriven(mdb);
        this.mdbDao.commit();
    }

    protected void processEntityElement(EjbConfigurationFacet ejbConfig, Element element) {
        String ejbClz;
        String localHomeClz;
        JavaClass localHome = null;
        JavaClass local = null;
        JavaClass ejb = null;
        String ejbId = this.extractAttributeAndTrim(element, "id");
        String displayName = this.extractChildTagAndTrim(element, "display-name");
        String ejbName = this.extractChildTagAndTrim(element, "ejb-name");
        String localClz = this.extractChildTagAndTrim(element, "local");
        if (localClz != null) {
            local = this.javaClassDao.getJavaClass(localClz);
        }
        if ((localHomeClz = this.extractChildTagAndTrim(element, "local-home")) != null) {
            localHome = this.javaClassDao.getJavaClass(localHomeClz);
        }
        if ((ejbClz = this.extractChildTagAndTrim(element, "ejb-class")) != null) {
            ejb = this.javaClassDao.getJavaClass(ejbClz);
        }
        String persistenceType = this.extractChildTagAndTrim(element, "persistence-type");
        EjbEntityFacet entity = (EjbEntityFacet)this.ejbEntityDao.create();
        entity.setPersistenceType(persistenceType);
        entity.setEjbId(ejbId);
        entity.setDisplayName(displayName);
        entity.setEjbEntityName(ejbName);
        entity.setJavaClassFacet(ejb);
        entity.setEjbLocalHome(localHome);
        entity.setEjbLocal(local);
        List<EnvironmentReference> refs = this.processEnvironmentReference(element);
        for (EnvironmentReference ref : refs) {
            entity.addMeta((Meta)ref);
        }
        ejbConfig.addEjbEntity(entity);
        this.ejbEntityDao.commit();
    }

    protected List<EnvironmentReference> processEnvironmentReference(Element element) {
        LinkedList<EnvironmentReference> resources = new LinkedList<EnvironmentReference>();
        List queueReferences = JOOX.$((Element)element).find("resource-env-ref").get();
        for (Element e : queueReferences) {
            String type = JOOX.$((Element)e).child("resource-env-ref-type").text();
            String name = JOOX.$((Element)e).child("resource-env-ref-name").text();
            type = StringUtils.trim((String)type);
            name = StringUtils.trim((String)name);
            EnvironmentReference ref = this.envRefDao.createEnvironmentReference(name, type);
            LOG.info("Adding name: " + name + ", type: " + type);
            resources.add(ref);
        }
        return resources;
    }

    protected String extractAttributeAndTrim(Element element, String property) {
        String result = JOOX.$((Element)element).attr(property);
        return StringUtils.trimToNull((String)result);
    }

    protected String extractChildTagAndTrim(Element element, String property) {
        String result = JOOX.$((Element)element).find(property).first().text();
        return StringUtils.trimToNull((String)result);
    }
}

