/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.engine.visitor.inspector;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.engine.visitor.AbstractGraphVisitor;
import org.jboss.windup.engine.visitor.VisitorPhase;
import org.jboss.windup.graph.dao.DoctypeDao;
import org.jboss.windup.graph.dao.HibernateConfigurationDao;
import org.jboss.windup.graph.model.meta.xml.DoctypeMeta;
import org.jboss.windup.graph.model.meta.xml.HibernateConfigurationFacet;
import org.jboss.windup.graph.model.resource.XmlResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateConfigurationVisitor
extends AbstractGraphVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(HibernateConfigurationVisitor.class);
    private static final String hibernateRegex = "(?i).*hibernate.configuration.*";
    @Inject
    private DoctypeDao doctypeDao;
    @Inject
    private HibernateConfigurationDao hibernateConfigurationDao;

    @Override
    public VisitorPhase getPhase() {
        return VisitorPhase.COMPOSITION;
    }

    @Override
    public void run() {
        long total = this.doctypeDao.count(this.doctypeDao.findSystemIdOrPublicIdMatchingRegex(new String[]{hibernateRegex}));
        int i = 1;
        for (DoctypeMeta doctype : this.doctypeDao.findSystemIdOrPublicIdMatchingRegex(new String[]{hibernateRegex})) {
            LOG.info("Processed " + ++i + " of " + " Doctypes.");
            this.visitDoctype(doctype);
        }
    }

    @Override
    public void visitDoctype(DoctypeMeta entry) {
        LOG.info("Doctype: ");
        LOG.info("  - publicId [" + entry.getPublicId() + "]");
        LOG.info("  - systemId [" + entry.getSystemId() + "]");
        String publicId = entry.getPublicId();
        String systemId = entry.getSystemId();
        String versionInformation = this.extractVersion(publicId, systemId);
        for (XmlResource xml : entry.getXmlResources()) {
            HibernateConfigurationFacet facet = (HibernateConfigurationFacet)this.hibernateConfigurationDao.create();
            facet.setXmlFacet(xml);
            if (!StringUtils.isNotBlank((String)versionInformation)) continue;
            facet.setSpecificationVersion(versionInformation);
        }
    }

    protected String extractVersion(String publicId, String systemId) {
        Matcher matcher;
        Pattern pattern = Pattern.compile("[0-9][0-9a-zA-Z.-]+");
        if (StringUtils.isNotBlank((String)publicId) && (matcher = pattern.matcher(publicId)).find()) {
            return matcher.group();
        }
        if (StringUtils.isNotBlank((String)systemId) && (matcher = pattern.matcher(systemId)).find()) {
            String match = matcher.group();
            return StringUtils.removeEnd((String)match, (String)".dtd");
        }
        return null;
    }
}

