/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.engine.visitor.inspector;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.engine.util.xml.XmlUtil;
import org.jboss.windup.engine.visitor.AbstractGraphVisitor;
import org.jboss.windup.engine.visitor.VisitorPhase;
import org.jboss.windup.graph.dao.DoctypeDao;
import org.jboss.windup.graph.dao.HibernateEntityDao;
import org.jboss.windup.graph.dao.HibernateMappingDao;
import org.jboss.windup.graph.dao.JavaClassDao;
import org.jboss.windup.graph.dao.XmlResourceDao;
import org.jboss.windup.graph.model.meta.javaclass.HibernateEntityFacet;
import org.jboss.windup.graph.model.meta.xml.DoctypeMeta;
import org.jboss.windup.graph.model.meta.xml.HibernateMappingFacet;
import org.jboss.windup.graph.model.resource.JavaClass;
import org.jboss.windup.graph.model.resource.XmlResource;
import org.joox.JOOX;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HibernateMappingVisitor
extends AbstractGraphVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(HibernateMappingVisitor.class);
    private static final String hibernateRegex = "(?i).*hibernate.mapping.*";
    @Inject
    private DoctypeDao doctypeDao;
    @Inject
    private HibernateEntityDao hibernateEntityDao;
    @Inject
    private HibernateMappingDao hibernateMappingDao;
    @Inject
    private JavaClassDao javaClassDao;
    @Inject
    private XmlResourceDao xmlResourceDao;

    @Override
    public VisitorPhase getPhase() {
        return VisitorPhase.COMPOSITION;
    }

    @Override
    public void run() {
        long total = this.doctypeDao.count(this.doctypeDao.findSystemIdOrPublicIdMatchingRegex(new String[]{hibernateRegex}));
        int i = 1;
        for (DoctypeMeta doctype : this.doctypeDao.findSystemIdOrPublicIdMatchingRegex(new String[]{hibernateRegex})) {
            LOG.info("Processed " + ++i + " of " + " Doctypes.");
            this.visitDoctype(doctype);
        }
        this.javaClassDao.commit();
    }

    @Override
    public void visitDoctype(DoctypeMeta entry) {
        LOG.info("Doctype: ");
        LOG.info("  - publicId [" + entry.getPublicId() + "]");
        LOG.info("  - systemId [" + entry.getSystemId() + "]");
        String publicId = entry.getPublicId();
        String systemId = entry.getSystemId();
        String versionInformation = this.extractVersion(publicId, systemId);
        int batch = 0;
        for (XmlResource xml : entry.getXmlResources()) {
            HibernateMappingFacet hibernateMapping = (HibernateMappingFacet)this.hibernateMappingDao.create();
            hibernateMapping.setXmlFacet(xml);
            Document doc = this.xmlResourceDao.asDocument(xml);
            if (!XmlUtil.xpathExists((Node)doc, (String)"/hibernate-mapping", null)) {
                LOG.warn("Docment does not contain Hibernate Mapping.");
                continue;
            }
            String clzPkg = JOOX.$((Document)doc).xpath("/hibernate-mapping").attr("package");
            String clzName = JOOX.$((Document)doc).xpath("/hibernate-mapping/class").attr("name");
            String tableName = JOOX.$((Document)doc).xpath("/hibernate-mapping/class").attr("table");
            String schemaName = JOOX.$((Document)doc).xpath("/hibernate-mapping/class").attr("schema");
            String catalogName = JOOX.$((Document)doc).xpath("/hibernate-mapping/class").attr("catalog");
            if (StringUtils.isBlank((String)clzName)) {
                LOG.debug("Docment does not contain class name. Skipping.");
                continue;
            }
            if (StringUtils.isNotBlank((String)clzPkg) && !StringUtils.startsWith((String)clzName, (String)clzPkg)) {
                clzName = clzPkg + "." + clzName;
            }
            JavaClass clz = this.javaClassDao.getJavaClass(clzName);
            HibernateEntityFacet hibernateEntity = (HibernateEntityFacet)this.hibernateEntityDao.create();
            hibernateEntity.setSpecificationVersion(versionInformation);
            hibernateEntity.setJavaClassFacet(clz);
            hibernateEntity.setTableName(tableName);
            hibernateEntity.setSchemaName(schemaName);
            hibernateEntity.setCatalogName(catalogName);
            hibernateMapping.setHibernateEntity(hibernateEntity);
            if (StringUtils.isNotBlank((String)versionInformation)) {
                hibernateEntity.setSpecificationVersion(versionInformation);
                hibernateMapping.setSpecificationVersion(versionInformation);
            }
            if (batch % 100 == 0 && batch > 0) {
                this.javaClassDao.commit();
            }
            ++batch;
        }
    }

    protected String extractVersion(String publicId, String systemId) {
        Matcher matcher;
        Pattern pattern = Pattern.compile("[0-9][0-9a-zA-Z.-]+");
        if (StringUtils.isNotBlank((String)publicId) && (matcher = pattern.matcher(publicId)).find()) {
            return matcher.group();
        }
        if (StringUtils.isNotBlank((String)systemId) && (matcher = pattern.matcher(systemId)).find()) {
            String match = matcher.group();
            return StringUtils.removeEnd((String)match, (String)".dtd");
        }
        return null;
    }
}

