/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.engine.visitor.inspector;

import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.Visitor;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.graph.dao.JavaClassDao;
import org.jboss.windup.graph.model.resource.JavaClass;
import org.jboss.windup.graph.model.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaClassReader
extends EmptyVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(JavaClassReader.class);
    private final org.apache.bcel.classfile.JavaClass javaClass;
    private final JavaClassDao javaClassDao;
    private JavaClass current;
    private final Resource resource;

    public JavaClassReader(org.apache.bcel.classfile.JavaClass clz, JavaClassDao javaClassDao, Resource resource) {
        this.javaClass = clz;
        this.javaClassDao = javaClassDao;
        this.resource = resource;
    }

    public void process() {
        this.javaClass.accept((Visitor)this);
    }

    public void visitJavaClass(org.apache.bcel.classfile.JavaClass obj) {
        Constant[] pool;
        this.current = this.javaClassDao.getJavaClass(obj.getClassName());
        int major = obj.getMajor();
        int minor = obj.getMinor();
        this.current.setMajorVersion(major);
        this.current.setMinorVersion(minor);
        this.current.addResource(this.resource);
        this.current.setPackageName(obj.getPackageName());
        for (String interfaceName : obj.getInterfaceNames()) {
            JavaClass interfaceClass = this.javaClassDao.getJavaClass(interfaceName);
            this.current.addImplements(interfaceClass);
        }
        for (Constant c : pool = obj.getConstantPool().getConstantPool()) {
            if (c == null) continue;
            c.accept((Visitor)this);
        }
        String superClz = obj.getSuperclassName();
        JavaClass superJavaClass = this.javaClassDao.getJavaClass(superClz);
        this.current.setExtends(superJavaClass);
    }

    public void visitConstantClass(ConstantClass obj) {
        ConstantPool pool = this.javaClass.getConstantPool();
        String classVal = obj.getConstantValue(pool).toString();
        if (StringUtils.equals((String)(classVal = StringUtils.replace((String)classVal, (String)"/", (String)".")), (String)this.javaClass.getClassName())) {
            return;
        }
        JavaClass clz = this.javaClassDao.getJavaClass(classVal);
        this.current.addImport(clz);
    }
}

