/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.engine.visitor.inspector;

import java.io.IOException;
import javax.inject.Inject;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.jboss.windup.engine.visitor.AbstractGraphVisitor;
import org.jboss.windup.engine.visitor.VisitorPhase;
import org.jboss.windup.engine.visitor.inspector.JavaClassReader;
import org.jboss.windup.graph.dao.ArchiveEntryDao;
import org.jboss.windup.graph.dao.JavaClassDao;
import org.jboss.windup.graph.model.resource.ArchiveEntryResource;
import org.jboss.windup.graph.model.resource.ArchiveResource;
import org.jboss.windup.graph.model.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaClassVisitor
extends AbstractGraphVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(JavaClassVisitor.class);
    @Inject
    private JavaClassDao javaClassDao;
    @Inject
    private ArchiveEntryDao archiveEntryDao;

    @Override
    public VisitorPhase getPhase() {
        return VisitorPhase.INITIAL_ANALYSIS;
    }

    @Override
    public void run() {
        int total = (int)this.archiveEntryDao.count(this.archiveEntryDao.findArchiveEntryWithExtension(new String[]{"class"}));
        int i = 0;
        for (ArchiveEntryResource entry : this.archiveEntryDao.findArchiveEntryWithExtension(new String[]{"class"})) {
            this.visitArchiveEntry(entry);
            if (i > 0 && i % 1000 == 0) {
                LOG.info("Processed: " + i + " of " + total + " Java Classes.");
                this.archiveEntryDao.commit();
            }
            ++i;
        }
        LOG.info("Processed: " + i + " of " + total + " Java Classes.");
        this.archiveEntryDao.commit();
    }

    @Override
    public void visitArchiveEntry(ArchiveEntryResource entry) {
        ArchiveResource archive = entry.getArchive();
        if (archive == null) {
            LOG.warn("Archive should not be null: " + entry.asVertex());
            return;
        }
        try {
            ClassParser classParser = new ClassParser(archive.getFileResource().getFilePath(), entry.getArchiveEntry());
            JavaClass parsed = classParser.parse();
            JavaClassReader iv = new JavaClassReader(parsed, this.javaClassDao, (Resource)entry);
            iv.process();
        }
        catch (IOException e) {
            LOG.error("Exception reading class.", (Throwable)e);
        }
    }
}

