/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.engine.visitor.inspector;

import java.io.IOException;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.engine.visitor.AbstractGraphVisitor;
import org.jboss.windup.engine.visitor.VisitorPhase;
import org.jboss.windup.graph.dao.EarArchiveDao;
import org.jboss.windup.graph.dao.JarArchiveDao;
import org.jboss.windup.graph.dao.JarManifestDao;
import org.jboss.windup.graph.dao.WarArchiveDao;
import org.jboss.windup.graph.model.meta.JarManifest;
import org.jboss.windup.graph.model.resource.JarArchive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestVisitor
extends AbstractGraphVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestVisitor.class);
    @Inject
    private WarArchiveDao warDao;
    @Inject
    private JarArchiveDao jarDao;
    @Inject
    private EarArchiveDao earDao;
    @Inject
    private JarManifestDao manifestDao;

    @Override
    public VisitorPhase getPhase() {
        return VisitorPhase.INITIAL_ANALYSIS;
    }

    @Override
    public void run() {
        for (JarArchive archive : this.jarDao.getAll()) {
            this.visitJarArchive(archive);
        }
        for (JarArchive archive : this.warDao.getAll()) {
            this.visitJarArchive(archive);
        }
        for (JarArchive archive : this.earDao.getAll()) {
            this.visitJarArchive(archive);
        }
        this.manifestDao.commit();
    }

    @Override
    public void visitJarArchive(JarArchive entry) {
        try {
            JarFile file = this.jarDao.asJarFile(entry);
            Manifest fileManifest = file.getManifest();
            if (fileManifest == null || fileManifest.getMainAttributes().size() == 0) {
                return;
            }
            JarManifest manifest = (JarManifest)this.manifestDao.create();
            manifest.setJarArchive(entry);
            for (Object key : fileManifest.getMainAttributes().keySet()) {
                String property = StringUtils.trim((String)key.toString());
                String propertyValue = StringUtils.trim((String)fileManifest.getMainAttributes().get(key).toString());
                manifest.setProperty(property, propertyValue);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to open JAR.", e);
        }
    }
}

