/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.engine.visitor.inspector;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.engine.util.xml.XmlUtil;
import org.jboss.windup.engine.visitor.AbstractGraphVisitor;
import org.jboss.windup.engine.visitor.VisitorPhase;
import org.jboss.windup.graph.dao.MavenFacetDao;
import org.jboss.windup.graph.dao.XmlResourceDao;
import org.jboss.windup.graph.model.meta.xml.MavenFacet;
import org.jboss.windup.graph.model.resource.XmlResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MavenRemoteFetchVisitor
extends AbstractGraphVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(MavenRemoteFetchVisitor.class);
    private final Map<String, String> namespaces = new HashMap<String, String>();
    @Inject
    private MavenFacetDao mavenDao;
    @Inject
    private XmlResourceDao xmlResourceDao;

    public MavenRemoteFetchVisitor() {
        this.namespaces.put("pom", "http://maven.apache.org/POM/4.0.0");
    }

    @Override
    public VisitorPhase getPhase() {
        return VisitorPhase.COMPOSITION;
    }

    @Override
    public void run() {
        for (XmlResource entry : this.xmlResourceDao.containsNamespaceURI("http://maven.apache.org/POM/4.0.0")) {
            this.visitXmlResource(entry);
        }
        this.mavenDao.commit();
    }

    @Override
    public void visitXmlResource(XmlResource entry) {
        LOG.info("Resource: " + entry.getResource().asVertex());
        try {
            Document document = this.xmlResourceDao.asDocument(entry);
            String modelVersion = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:modelVersion", this.namespaces);
            String name = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:name", this.namespaces);
            String description = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:description", this.namespaces);
            String url = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:url", this.namespaces);
            String groupId = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:groupId", this.namespaces);
            String artifactId = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:artifactId", this.namespaces);
            String version = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:version", this.namespaces);
            String parentGroupId = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:parent/pom:groupId", this.namespaces);
            String parentArtifactId = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:parent/pom:artifactId", this.namespaces);
            String parentVersion = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:parent/pom:version", this.namespaces);
            if (StringUtils.isBlank((String)groupId) && StringUtils.isNotBlank((String)parentGroupId)) {
                groupId = parentGroupId;
            }
            if (StringUtils.isBlank((String)version) && StringUtils.isNotBlank((String)parentVersion)) {
                version = parentVersion;
            }
            MavenFacet facet = this.mavenDao.createMaven(groupId, artifactId, version);
            facet.setXmlFacet(entry);
            if (StringUtils.isNotBlank((String)name)) {
                facet.setName(StringUtils.trim((String)name));
            }
            if (StringUtils.isNotBlank((String)description)) {
                facet.setDescription(StringUtils.trim((String)description));
            }
            if (StringUtils.isNotBlank((String)url)) {
                facet.setURL(StringUtils.trim((String)url));
            }
            if (StringUtils.isNotBlank((String)modelVersion)) {
                facet.setSpecificationVersion(modelVersion);
            }
            if (StringUtils.isNotBlank((String)parentGroupId)) {
                MavenFacet parent = this.mavenDao.createMaven(parentGroupId, parentArtifactId, parentVersion);
                facet.setParent(parent);
            }
            NodeList nodes = XmlUtil.xpathNodeList((Node)document, (String)"/pom:project/pom:dependencies/pom:dependency", this.namespaces);
            int j = nodes.getLength();
            for (int i = 0; i < j; ++i) {
                Node node = nodes.item(i);
                String dependencyGroupId = XmlUtil.xpathExtract((Node)node, (String)"./pom:groupId", this.namespaces);
                String dependencyArtifactId = XmlUtil.xpathExtract((Node)node, (String)"./pom:artifactId", this.namespaces);
                String dependencyVersionId = XmlUtil.xpathExtract((Node)node, (String)"./pom:version", this.namespaces);
                if (!StringUtils.isNotBlank((String)dependencyGroupId)) continue;
                MavenFacet dependency = this.mavenDao.createMaven(dependencyGroupId, dependencyArtifactId, dependencyVersionId);
                facet.addDependency(dependency);
            }
            LOG.info("Successfully read XML..");
        }
        catch (Exception e) {
            LOG.error("Exception reading document.", (Throwable)e);
        }
    }
}

