/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.engine.visitor.inspector;

import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.engine.visitor.AbstractGraphVisitor;
import org.jboss.windup.engine.visitor.VisitorPhase;
import org.jboss.windup.graph.dao.JavaClassDao;
import org.jboss.windup.graph.dao.SpringBeanDao;
import org.jboss.windup.graph.dao.SpringConfigurationDao;
import org.jboss.windup.graph.dao.XmlResourceDao;
import org.jboss.windup.graph.model.meta.javaclass.SpringBeanFacet;
import org.jboss.windup.graph.model.meta.xml.SpringConfigurationFacet;
import org.jboss.windup.graph.model.resource.JavaClass;
import org.jboss.windup.graph.model.resource.XmlResource;
import org.joox.JOOX;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SpringConfigurationVisitor
extends AbstractGraphVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(SpringConfigurationVisitor.class);
    @Inject
    private XmlResourceDao xmlResourceDao;
    @Inject
    private SpringConfigurationDao springConfigurationDao;
    @Inject
    private SpringBeanDao springBeanDao;
    @Inject
    private JavaClassDao javaClassDao;

    @Override
    public VisitorPhase getPhase() {
        return VisitorPhase.INITIAL_ANALYSIS;
    }

    @Override
    public void run() {
        for (XmlResource entry : this.xmlResourceDao.findByRootTag("beans")) {
            this.visitXmlResource(entry);
            this.xmlResourceDao.commit();
        }
    }

    @Override
    public void visitXmlResource(XmlResource entry) {
        try {
            Document doc = this.xmlResourceDao.asDocument(entry);
            Element element = (Element)JOOX.$((Document)doc).namespace("s", "http://www.springframework.org/schema/beans").xpath("/s:beans").get().get(0);
            if (element != null) {
                SpringConfigurationFacet facet = (SpringConfigurationFacet)this.springConfigurationDao.create();
                facet.setXmlFacet(entry);
                List beans = JOOX.$((Element)element).children("bean").get();
                for (Element bean : beans) {
                    String clz = JOOX.$((Element)bean).attr("class");
                    String id = JOOX.$((Element)bean).attr("id");
                    String name = JOOX.$((Element)bean).attr("name");
                    if (StringUtils.isBlank((String)id) && StringUtils.isNotBlank((String)name)) {
                        id = name;
                    }
                    if (StringUtils.isBlank((String)clz)) {
                        LOG.warn("Spring Bean did not include class:" + JOOX.$((Element)bean).toString());
                        continue;
                    }
                    SpringBeanFacet springBeanRef = (SpringBeanFacet)this.springBeanDao.create();
                    if (StringUtils.isNotBlank((String)id)) {
                        springBeanRef.setSpringBeanName(id);
                    }
                    JavaClass classReference = this.javaClassDao.getJavaClass(clz);
                    springBeanRef.setJavaClassFacet(classReference);
                    facet.addSpringBeanReference(springBeanRef);
                }
            } else {
                LOG.warn("Found [beans] XML without namespace.");
            }
        }
        catch (Exception e) {
            LOG.error("Error.", (Throwable)e);
        }
    }
}

