/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.engine.visitor.inspector;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.engine.util.xml.DoctypeUtils;
import org.jboss.windup.engine.util.xml.NamespaceUtils;
import org.jboss.windup.engine.visitor.AbstractGraphVisitor;
import org.jboss.windup.engine.visitor.VisitorPhase;
import org.jboss.windup.graph.dao.EnvironmentReferenceDao;
import org.jboss.windup.graph.dao.WebConfigurationDao;
import org.jboss.windup.graph.dao.XmlResourceDao;
import org.jboss.windup.graph.model.meta.EnvironmentReference;
import org.jboss.windup.graph.model.meta.Meta;
import org.jboss.windup.graph.model.meta.xml.DoctypeMeta;
import org.jboss.windup.graph.model.meta.xml.NamespaceMeta;
import org.jboss.windup.graph.model.meta.xml.WebConfigurationFacet;
import org.jboss.windup.graph.model.resource.XmlResource;
import org.joox.JOOX;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WebConfigurationVisitor
extends AbstractGraphVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(WebConfigurationVisitor.class);
    private static final String dtdRegex = "(?i).*web.application.*";
    @Inject
    private EnvironmentReferenceDao envRefDao;
    @Inject
    private WebConfigurationDao webConfigurationDao;
    @Inject
    private XmlResourceDao xmlDao;

    @Override
    public VisitorPhase getPhase() {
        return VisitorPhase.INITIAL_ANALYSIS;
    }

    @Override
    public void run() {
        for (XmlResource xml : this.xmlDao.findByRootTag("web-app")) {
            Document doc = this.xmlDao.asDocument(xml);
            String version = null;
            if (xml.getDoctype() != null) {
                if (!this.processDoctypeMatches(xml.getDoctype())) continue;
                version = this.processDoctypeVersion(xml.getDoctype());
            } else {
                version = JOOX.$((Document)doc).find("web-app").first().attr("version");
                if (StringUtils.isBlank((String)version)) {
                    String namespace = JOOX.$((Document)doc).find("web-app").namespaceURI();
                    if (StringUtils.isBlank((String)namespace)) {
                        namespace = doc.getFirstChild().getNamespaceURI();
                    }
                    for (NamespaceMeta ns : xml.getNamespaces()) {
                        if (!StringUtils.equals((String)ns.getURI(), (String)namespace)) continue;
                        version = NamespaceUtils.extractVersion((String)ns.getSchemaLocation());
                        break;
                    }
                }
            }
            this.visitXmlResource(xml, doc, version);
        }
    }

    public void visitXmlResource(XmlResource xml, Document doc, String versionInformation) {
        WebConfigurationFacet facet = (WebConfigurationFacet)this.webConfigurationDao.create();
        facet.setXmlFacet(xml);
        if (StringUtils.isNotBlank((String)versionInformation)) {
            versionInformation = StringUtils.replace((String)versionInformation, (String)"_", (String)".");
            facet.setSpecificationVersion(versionInformation);
        }
        String displayName = JOOX.$((Document)doc).child("display-name").text();
        if (StringUtils.isNotBlank((String)(displayName = StringUtils.trimToNull((String)displayName)))) {
            facet.setDisplayName(displayName);
        }
        List<EnvironmentReference> refs = this.processEnvironmentReference(doc.getDocumentElement());
        for (EnvironmentReference ref : refs) {
            facet.addMeta((Meta)ref);
        }
    }

    public boolean processDoctypeMatches(DoctypeMeta entry) {
        if (StringUtils.isNotBlank((String)entry.getPublicId()) && Pattern.matches(dtdRegex, entry.getPublicId())) {
            return true;
        }
        return StringUtils.isNotBlank((String)entry.getSystemId()) && Pattern.matches(dtdRegex, entry.getSystemId());
    }

    public String processDoctypeVersion(DoctypeMeta entry) {
        String publicId = entry.getPublicId();
        String systemId = entry.getSystemId();
        String versionInformation = DoctypeUtils.extractVersion((String)publicId, (String)systemId);
        return versionInformation;
    }

    protected List<EnvironmentReference> processEnvironmentReference(Element element) {
        LinkedList<EnvironmentReference> resources = new LinkedList<EnvironmentReference>();
        List queueReferences = JOOX.$((Element)element).find("resource-ref").get();
        for (Element e : queueReferences) {
            String id = JOOX.$((Element)e).attr("id");
            String type = JOOX.$((Element)e).child("res-type").text();
            String name = JOOX.$((Element)e).child("res-ref-name").text();
            type = StringUtils.trim((String)type);
            name = StringUtils.trim((String)name);
            EnvironmentReference ref = this.envRefDao.createEnvironmentReference(name, type);
            ref.setReferenceId(id);
            resources.add(ref);
        }
        return resources;
    }

    protected String extractAttributeAndTrim(Element element, String property) {
        String result = JOOX.$((Element)element).attr(property);
        return StringUtils.trimToNull((String)result);
    }

    protected String extractChildTagAndTrim(Element element, String property) {
        String result = JOOX.$((Element)element).find(property).first().text();
        return StringUtils.trimToNull((String)result);
    }
}

