/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.engine.visitor.inspector;

import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.jboss.windup.engine.util.xml.LocationAwareContentHandler;
import org.jboss.windup.engine.util.xml.LocationAwareXmlReader;
import org.jboss.windup.engine.util.xml.XmlUtil;
import org.jboss.windup.engine.visitor.AbstractGraphVisitor;
import org.jboss.windup.engine.visitor.VisitorPhase;
import org.jboss.windup.graph.dao.ArchiveEntryDao;
import org.jboss.windup.graph.dao.DoctypeDao;
import org.jboss.windup.graph.dao.NamespaceDao;
import org.jboss.windup.graph.dao.XmlResourceDao;
import org.jboss.windup.graph.model.meta.Meta;
import org.jboss.windup.graph.model.meta.xml.DoctypeMeta;
import org.jboss.windup.graph.model.meta.xml.NamespaceMeta;
import org.jboss.windup.graph.model.resource.ArchiveEntryResource;
import org.jboss.windup.graph.model.resource.Resource;
import org.jboss.windup.graph.model.resource.XmlResource;
import org.joox.JOOX;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class XmlResourceVisitor
extends AbstractGraphVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(XmlResourceVisitor.class);
    @Inject
    private DoctypeDao doctypeDao;
    @Inject
    private NamespaceDao namespaceDao;
    @Inject
    private XmlResourceDao xmlResourceDao;
    @Inject
    private ArchiveEntryDao archiveEntryDao;

    @Override
    public VisitorPhase getPhase() {
        return VisitorPhase.INITIAL_ANALYSIS;
    }

    @Override
    public void run() {
        int i = 0;
        for (ArchiveEntryResource entry : this.archiveEntryDao.findArchiveEntryWithExtension(new String[]{"xml"})) {
            this.visitArchiveEntry(entry);
            if (i % 10 != 0 || i <= 0) continue;
            this.archiveEntryDao.commit();
        }
        this.archiveEntryDao.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitArchiveEntry(ArchiveEntryResource entry) {
        InputStream is;
        block8: {
            is = null;
            try {
                Map namespaceSchemaLocations;
                is = this.archiveEntryDao.asInputStream(entry);
                Document parsedDocument = LocationAwareXmlReader.readXML((InputStream)is);
                LocationAwareContentHandler.Doctype docType = (LocationAwareContentHandler.Doctype)parsedDocument.getUserData("dt");
                XmlResource resource = (XmlResource)this.xmlResourceDao.create();
                resource.setResource((Resource)entry);
                String tagName = JOOX.$((Document)parsedDocument).tag();
                resource.setRootTagName(tagName);
                if (docType != null) {
                    DoctypeMeta meta;
                    Iterator metas = this.doctypeDao.findByProperties(docType.getPublicId(), docType.getSystemId());
                    if (metas.hasNext()) {
                        meta = (DoctypeMeta)metas.next();
                        meta.addXmlResource(resource);
                        resource.addMeta((Meta)meta);
                    } else {
                        LOG.debug("Adding doctype: " + docType);
                        meta = (DoctypeMeta)this.doctypeDao.create();
                        meta.setBaseURI(docType.getBaseURI());
                        meta.setName(docType.getName());
                        meta.setPublicId(docType.getPublicId());
                        meta.setSystemId(docType.getSystemId());
                    }
                }
                if ((namespaceSchemaLocations = XmlUtil.getSchemaLocations((Document)parsedDocument)) == null || namespaceSchemaLocations.size() <= 0) break block8;
                for (String namespace : namespaceSchemaLocations.keySet()) {
                    NamespaceMeta meta = this.namespaceDao.createNamespaceSchemaLocation(namespace, (String)namespaceSchemaLocations.get(namespace));
                    meta.addXmlResource(resource);
                }
            }
            catch (Exception e) {
                try {
                    LOG.error("Encountered Exception: " + e.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        IOUtils.closeQuietly((InputStream)is);
    }
}

